/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.IScrollable;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class SelectionLogic<S>
implements IScrollable {
    private static final int SELECTABLE_PER_ROW = 11;
    private final ISelectableProvider<S> provider;
    private final Comparator<S> comparator;
    private final SelectionWidget widget;
    private final Collection<S> entries;
    private ArrayList<S> sorted = new ArrayList();
    private Set<SelectableWidget> visible = new HashSet<SelectableWidget>();

    public SelectionLogic(SelectionWidget widget, ISelectableProvider<S> provider) {
        this.widget = widget;
        this.provider = provider;
        this.entries = provider.getEntries();
        this.comparator = (f, s) -> provider.getName(f).getString().compareToIgnoreCase(provider.getName(s).getString());
    }

    public boolean isSame(ISelectableProvider provider) {
        return this.provider == provider;
    }

    @Override
    public void onScroll(int value) {
        this.visible.clear();
        int startIndex = value * 11;
        block0: for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 11; ++x) {
                int index = startIndex + y * 11 + x;
                if (index >= this.sorted.size()) break block0;
                this.visible.add(new SelectableWidget(this.sorted.get(index), this.widget.getX() + 12 + x * 16, this.widget.getY() + 16 + y * 16));
            }
        }
    }

    public Set<SelectableWidget> getVisible() {
        return this.visible;
    }

    public void filterEntries(String searchText) {
        Pattern pattern;
        this.sorted.clear();
        this.sorted.ensureCapacity(this.entries.size());
        try {
            pattern = Pattern.compile(searchText.toLowerCase(Locale.ENGLISH), 2);
        }
        catch (Throwable ignore) {
            try {
                pattern = Pattern.compile(Pattern.quote(searchText.toLowerCase(Locale.ENGLISH)), 2);
            }
            catch (Throwable e) {
                return;
            }
        }
        for (S entry : this.entries) {
            ITextComponent name = this.provider.getName(entry);
            if (!pattern.matcher(name.getString().toLowerCase(Locale.ENGLISH)).find()) continue;
            this.sorted.add(entry);
        }
        this.sorted.sort(this.comparator);
        int elements = this.sorted.size() / 11 - 4;
        if (elements > 0) {
            this.widget.scrollBar.setParameters(this, 0, elements, 1);
        } else {
            this.onScroll(0);
        }
        this.widget.scrollBar.setVisible(elements > 0);
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.widget.isMouseOver(mouseX, mouseY);
    }

    public void draw(MatrixStack transform) {
        for (SelectableWidget selectable : this.visible) {
            selectable.draw(this.widget.gui, transform);
        }
    }

    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        for (SelectableWidget selectable : this.visible) {
            if (!selectable.isMouseOver(mouseX, mouseY)) continue;
            return selectable.getToolTip();
        }
        return null;
    }

    public void select(double mouseX, double mouseY) {
        mouseX -= (double)this.widget.gui.getGuiLeft();
        mouseY -= (double)this.widget.gui.getGuiTop();
        for (SelectableWidget selectable : this.visible) {
            if (!selectable.isMouseOver(mouseX, mouseY)) continue;
            this.provider.onSelect(selectable.selectable);
            break;
        }
    }

    private class SelectableWidget {
        private final S selectable;
        private final int xPos;
        private final int yPos;

        public SelectableWidget(S entry, int xPos, int yPos) {
            this.selectable = entry;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public void draw(GuiForestry gui, MatrixStack transform) {
            SelectionLogic.this.provider.draw(gui, this.selectable, transform, this.yPos, this.xPos);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.xPos && mouseX <= (double)(this.xPos + 16) && mouseY >= (double)this.yPos && mouseY <= (double)(this.yPos + 16);
        }

        public ToolTip getToolTip() {
            ToolTip toolTip = new ToolTip();
            toolTip.add(SelectionLogic.this.provider.getName(this.selectable));
            return toolTip;
        }
    }
}

