/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.compat;

import forestry.core.utils.RecipeUtils;
import forestry.worktable.gui.ContainerWorktable;
import forestry.worktable.inventory.CraftingInventoryForestry;
import forestry.worktable.recipes.MemorizedRecipe;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class WorktableRecipeTransferHandler
implements IRecipeTransferHandler<ContainerWorktable> {
    WorktableRecipeTransferHandler() {
    }

    public Class<ContainerWorktable> getContainerClass() {
        return ContainerWorktable.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ContainerWorktable container, Object recipe, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (doTransfer) {
            Map guiIngredients = recipeLayout.getItemStacks().getGuiIngredients();
            CraftingInventoryForestry inventory = new CraftingInventoryForestry(container);
            for (Map.Entry entry : guiIngredients.entrySet()) {
                int recipeSlot = (Integer)entry.getKey();
                List allIngredients = ((IGuiIngredient)entry.getValue()).getAllIngredients();
                if (allIngredients.isEmpty() || recipeSlot == 0) continue;
                ItemStack firstIngredient = (ItemStack)allIngredients.get(0);
                inventory.func_70299_a(recipeSlot - 1, firstIngredient);
            }
            List<ICraftingRecipe> matchingRecipes = RecipeUtils.findMatchingRecipes(inventory, player.field_70170_p);
            if (!matchingRecipes.isEmpty()) {
                MemorizedRecipe memorizedRecipe = new MemorizedRecipe(inventory, matchingRecipes);
                container.sendWorktableRecipeRequest(memorizedRecipe);
            }
        }
        return null;
    }
}

