/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.widgets.ItemStackWidgetBase;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.SoundUtil;
import forestry.worktable.gui.ContainerWorktable;
import forestry.worktable.recipes.RecipeMemory;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;

public class MemorizedRecipeSlot
extends ItemStackWidgetBase {
    private static final TextureAtlasSprite lockIcon = TextureManagerForestry.getInstance().getDefault("slots/locked");
    private final RecipeMemory recipeMemory;
    private final int slotNumber;

    public MemorizedRecipeSlot(WidgetManager manager, int xPos, int yPos, RecipeMemory recipeMemory, int slot) {
        super(manager, xPos, yPos);
        this.recipeMemory = recipeMemory;
        this.slotNumber = slot;
    }

    @Override
    public ItemStack getItemStack() {
        return this.recipeMemory.getRecipeDisplayOutput(this.slotNumber);
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        super.draw(transform, startY, startX);
        RenderSystem.disableDepthTest();
        if (this.recipeMemory.isLocked(this.slotNumber)) {
            TextureManagerForestry.getInstance().bindGuiTextureMap();
            AbstractGui.func_238470_a_((MatrixStack)transform, (int)(startX + this.xPos), (int)(startY + this.yPos), (int)this.manager.gui.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)lockIcon);
        }
        RenderSystem.enableDepthTest();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (!this.getItemStack().func_190926_b()) {
            ContainerWorktable.sendRecipeClick(mouseButton, this.slotNumber);
            SoundUtil.playButtonClick();
        }
    }
}

