/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.tiles;

import com.google.common.base.Preconditions;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.RecipeUtils;
import forestry.worktable.features.WorktableTiles;
import forestry.worktable.gui.ContainerWorktable;
import forestry.worktable.inventory.CraftingInventoryForestry;
import forestry.worktable.inventory.InventoryWorktable;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.tiles.ICrafterWorktable;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private RecipeMemory recipeMemory;
    private final InventoryAdapterTile<TileWorktable> craftingDisplay;
    @Nullable
    private MemorizedRecipe currentRecipe;

    public TileWorktable() {
        super(WorktableTiles.WORKTABLE.tileType());
        this.setInternalInventory(new InventoryWorktable(this));
        this.craftingDisplay = new InventoryGhostCrafting<TileWorktable>(this, 10);
        this.recipeMemory = new RecipeMemory();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.craftingDisplay.write(compoundNBT);
        this.recipeMemory.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.craftingDisplay.read(compoundNBT);
        this.recipeMemory = new RecipeMemory(compoundNBT);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.craftingDisplay.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.craftingDisplay.readData(data);
        this.recipeMemory.readData(data);
    }

    public boolean hasRecipeConflict() {
        return this.currentRecipe != null && this.currentRecipe.hasRecipeConflict();
    }

    public void chooseNextConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.incrementRecipe();
        }
    }

    public void choosePreviousConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.decrementRecipe();
        }
    }

    @Override
    public ItemStack getResult(CraftingInventory inventory, World world) {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getCraftingResult(inventory, world);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canTakeStack(int craftingSlotIndex) {
        return craftingSlotIndex != 9 || this.canCraftCurrentRecipe();
    }

    private boolean canCraftCurrentRecipe() {
        return this.craftRecipe(true);
    }

    @Override
    public boolean onCraftingStart(PlayerEntity player) {
        return this.craftRecipe(false);
    }

    private boolean craftRecipe(boolean simulate) {
        if (this.currentRecipe == null) {
            return false;
        }
        ICraftingRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe(this.field_145850_b);
        if (selectedRecipe == null) {
            return false;
        }
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 0, 18);
        if (!InventoryUtil.consumeIngredients(inventory, (NonNullList<Ingredient>)selectedRecipe.func_192400_c(), null, true, false, !simulate)) {
            return false;
        }
        if (!simulate) {
            this.setCurrentRecipe(this.currentRecipe);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(PlayerEntity player) {
        Preconditions.checkNotNull((Object)this.currentRecipe);
        ICraftingRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe(this.field_145850_b);
        Preconditions.checkNotNull((Object)selectedRecipe);
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        CraftingInventoryForestry craftMatrix = this.currentRecipe.getCraftMatrix();
        NonNullList remainingItems = selectedRecipe.func_179532_b((IInventory)craftMatrix.copy());
        ForgeHooks.setCraftingPlayer(null);
        for (ItemStack remainingItem : remainingItems) {
            if (remainingItem == null || remainingItem.func_190926_b() || InventoryUtil.tryAddStack((IInventory)this, remainingItem, true)) continue;
            player.func_71019_a(remainingItem, false);
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.recipeMemory.memorizeRecipe(this.field_145850_b.func_82737_E(), this.currentRecipe, this.field_145850_b);
        }
    }

    @Nullable
    public ICraftingRecipe getRecipeUsed() {
        if (this.currentRecipe == null) {
            return null;
        }
        return this.currentRecipe.getSelectedRecipe(this.field_145850_b);
    }

    public RecipeMemory getMemory() {
        return this.recipeMemory;
    }

    public void chooseRecipeMemory(int recipeIndex) {
        MemorizedRecipe recipe = this.recipeMemory.getRecipe(recipeIndex);
        this.setCurrentRecipe(recipe);
    }

    private void setCraftingDisplay(IInventory craftMatrix) {
        for (int slot = 0; slot < craftMatrix.func_70302_i_(); ++slot) {
            ItemStack stack = craftMatrix.func_70301_a(slot);
            this.craftingDisplay.func_70299_a(slot, stack.func_77946_l());
        }
    }

    public IInventory getCraftingDisplay() {
        return new InventoryMapper((IInventory)this.craftingDisplay, 0, 9);
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public void setCurrentRecipe(CraftingInventoryForestry crafting) {
        MemorizedRecipe recipe;
        List<ICraftingRecipe> recipes = RecipeUtils.getRecipes(IRecipeType.field_222149_a, crafting, this.field_145850_b);
        MemorizedRecipe memorizedRecipe = recipe = recipes.isEmpty() ? null : new MemorizedRecipe(crafting, recipes);
        if (this.currentRecipe == null || recipe == null || recipe.hasRecipe(this.currentRecipe.getSelectedRecipe(this.field_145850_b), this.field_145850_b)) {
            // empty if block
        }
        this.setCurrentRecipe(recipe);
    }

    @Nullable
    public MemorizedRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(@Nullable MemorizedRecipe recipe) {
        this.currentRecipe = recipe;
        if (this.currentRecipe != null) {
            this.setCraftingDisplay((IInventory)this.currentRecipe.getCraftMatrix());
        }
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerWorktable(windowId, playerInventory, this);
    }
}

