/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.alleles;

import forestry.core.utils.Translator;
import genetics.api.alleles.AlleleValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class AlleleCategorizedValue<V>
extends AlleleValue<V> {
    private final String modId;
    private final String category;
    private final String valueName;

    public AlleleCategorizedValue(String modId, String category, String valueName, V value, boolean dominant) {
        super(AlleleCategorizedValue.getUnlocalizedName(modId, category, valueName), dominant, value);
        this.setRegistryName(AlleleCategorizedValue.createRegistryName(modId, category, valueName));
        this.modId = modId;
        this.category = category;
        this.valueName = valueName;
    }

    private static ResourceLocation createRegistryName(String modId, String category, String valueName) {
        return new ResourceLocation(modId, category + "_" + valueName);
    }

    private static String getUnlocalizedName(String modId, String category, String valueName) {
        return modId + '.' + "allele." + valueName;
    }

    @Override
    public ITextComponent getDisplayName() {
        String customName = this.modId + '.' + "allele." + this.category + '.' + this.valueName;
        return Translator.tryTranslate(customName, this.modId + '.' + "allele." + this.valueName);
    }
}

