/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.alleles;

import genetics.api.GeneticsAPI;
import genetics.api.alleles.AlleleCategorizedValue;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleProvider;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeType;
import genetics.utils.AlleleUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraftforge.fml.ModLoadingContext;

public interface IAlleleData<V>
extends IAlleleProvider {
    public V getValue();

    public boolean isDominant();

    public String getCategory();

    public String getName();

    default public Optional<IAlleleValue<V>> getAlleleValue() {
        return GeneticsAPI.apiInstance.getAlleleHelper().getAllele(this);
    }

    default public IAlleleValue<V> createAllele() {
        return new AlleleCategorizedValue<V>(ModLoadingContext.get().getActiveContainer().getModId(), this.getCategory(), this.getName(), this.getValue(), this.isDominant());
    }

    @Override
    default public IAllele getAllele() {
        Optional<IAlleleValue<V>> optionalAllele = this.getAlleleValue();
        if (!optionalAllele.isPresent()) {
            throw new IllegalStateException("Attempted to get the allele from an allele data that was not registered! Please register the allele data before you use it.");
        }
        return optionalAllele.get();
    }

    default public Collection<IChromosomeType> getTypes() {
        Optional<IAlleleValue<V>> optionalAllele = this.getAlleleValue();
        if (!optionalAllele.isPresent()) {
            return Collections.emptySet();
        }
        IAlleleValue<V> alleleValue = optionalAllele.get();
        return AlleleUtils.getChromosomeTypes(alleleValue);
    }
}

