/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.individual;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;

public interface IKaryotype
extends Iterable<IChromosomeType> {
    public String getUID();

    public IChromosomeType[] getChromosomeTypes();

    public boolean contains(IChromosomeType var1);

    public IChromosomeType getSpeciesType();

    public IAlleleTemplateBuilder createTemplate();

    public IAlleleTemplateBuilder createTemplate(IAllele[] var1);

    public IAlleleTemplateBuilder createEmptyTemplate();

    public IAlleleTemplate getDefaultTemplate();

    public int size();

    public IGenome getDefaultGenome();

    default public IChromosome[] templateAsChromosomes(IAllele[] template) {
        return this.templateAsChromosomes(template, null);
    }

    public IChromosome[] templateAsChromosomes(IAllele[] var1, @Nullable IAllele[] var2);

    default public IGenome templateAsGenome(IAllele[] template) {
        return this.templateAsGenome(template, null);
    }

    public IGenome templateAsGenome(IAllele[] var1, @Nullable IAllele[] var2);

    @Override
    default public Iterator<IChromosomeType> iterator() {
        return Arrays.stream(this.getChromosomeTypes()).iterator();
    }
}

