/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.individual;

import genetics.api.GeneticsAPI;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IIndividualBuilder;
import genetics.api.individual.IKaryotype;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class Individual
implements IIndividual {
    private static final String NBT_GENOME = "Genome";
    private static final String NBT_MATE = "Mate";
    private static final String NBT_ANALYZED = "IsAnalyzed";
    protected final IGenome genome;
    protected boolean isAnalyzed = false;
    @Nullable
    protected IGenome mate;

    public Individual(IGenome genome) {
        this.genome = genome;
    }

    public Individual(IGenome genome, @Nullable IGenome mate) {
        this.genome = genome;
        this.mate = mate;
    }

    public Individual(CompoundNBT compound) {
        IKaryotype karyotype = this.getRoot().getKaryotype();
        this.genome = compound.func_74764_b(NBT_GENOME) ? GeneticsAPI.apiInstance.getGeneticFactory().createGenome(karyotype, compound.func_74775_l(NBT_GENOME)) : karyotype.getDefaultGenome();
        if (compound.func_74764_b(NBT_MATE)) {
            this.mate = GeneticsAPI.apiInstance.getGeneticFactory().createGenome(karyotype, compound.func_74775_l(NBT_MATE));
        }
        this.isAnalyzed = compound.func_74767_n(NBT_ANALYZED);
    }

    @Override
    public String getIdentifier() {
        return this.genome.getActiveAllele(this.getRoot().getKaryotype().getSpeciesType()).getRegistryName().toString();
    }

    @Override
    public IGenome getGenome() {
        return this.genome;
    }

    @Override
    public boolean mate(@Nullable IGenome mate) {
        if (mate != null && mate.getKaryotype() != this.genome.getKaryotype()) {
            return false;
        }
        this.mate = mate;
        return true;
    }

    @Override
    public Optional<IGenome> getMate() {
        return Optional.ofNullable(this.mate);
    }

    @Override
    public boolean isPureBred(IChromosomeType geneType) {
        return this.genome.isPureBred(geneType);
    }

    @Override
    public boolean isGeneticEqual(IIndividual other) {
        return this.genome.isGeneticEqual(other.getGenome());
    }

    @Override
    public void onBuild(IIndividual otherIndividual) {
        if (otherIndividual.isAnalyzed()) {
            this.analyze();
        }
        Optional<IGenome> otherMate = otherIndividual.getMate();
        otherMate.ifPresent(this::mate);
    }

    @Override
    public IIndividualBuilder toBuilder() {
        return GeneticsAPI.apiInstance.getGeneticFactory().createIndividualBuilder(this);
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.func_218657_a(NBT_GENOME, (INBT)this.genome.writeToNBT(new CompoundNBT()));
        if (this.mate != null) {
            compound.func_218657_a(NBT_MATE, (INBT)this.mate.writeToNBT(new CompoundNBT()));
        }
        compound.func_74757_a(NBT_ANALYZED, this.isAnalyzed);
        return compound;
    }

    @Override
    public boolean analyze() {
        if (this.isAnalyzed) {
            return false;
        }
        this.isAnalyzed = true;
        return true;
    }

    @Override
    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }
}

