/*
 * Decompiled with CFR 0.152.
 */
package genetics.classification;

import genetics.api.classification.IClassification;
import genetics.api.classification.IClassificationHandler;
import genetics.api.classification.IClassificationRegistry;
import genetics.classification.Classification;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ClassificationRegistry
implements IClassificationRegistry {
    private final LinkedHashMap<String, IClassification> classificationMap = new LinkedHashMap(128);
    private final Set<IClassificationHandler> classificationHandlers = new HashSet<IClassificationHandler>();

    @Override
    public void registerClassification(IClassification branch) {
        if (this.classificationMap.containsKey(branch.getUID())) {
            throw new IllegalArgumentException(String.format("Could not add new classification '%s', because the key is already taken by %s.", branch.getUID(), this.classificationMap.get(branch.getUID())));
        }
        this.classificationMap.put(branch.getUID(), branch);
        for (IClassificationHandler handler : this.classificationHandlers) {
            handler.onRegisterClassification(branch);
        }
    }

    @Override
    public Map<String, IClassification> getRegisteredClassifications() {
        return Collections.unmodifiableMap(this.classificationMap);
    }

    @Override
    public IClassification createAndRegisterClassification(IClassification.EnumClassLevel level, String uid, String scientific) {
        return new Classification(level, uid, scientific);
    }

    @Override
    public IClassification createAndRegisterClassification(IClassification.EnumClassLevel level, String uid, String scientific, IClassification ... members) {
        Classification classification = new Classification(level, uid, scientific);
        for (IClassification member : members) {
            classification.addMemberGroup(member);
        }
        return classification;
    }

    @Override
    public IClassification getClassification(String uid) {
        return this.classificationMap.get(uid);
    }

    @Override
    public void registerHandler(IClassificationHandler handler) {
        this.classificationHandlers.add(handler);
    }

    @Override
    public Collection<IClassificationHandler> getHandlers() {
        return this.classificationHandlers;
    }
}

