/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.ApiInstance;
import genetics.Log;
import genetics.api.GeneticHelper;
import genetics.api.IGeneticSaveHandler;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.organism.IOrganismHandler;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.ITemplateContainer;
import genetics.individual.SaveFormat;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public enum GeneticSaveHandler implements IGeneticSaveHandler
{
    INSTANCE;

    private static final String GENOME_TAG = "Genome";
    private static SaveFormat writeFormat;

    public static void setWriteFormat(SaveFormat writeFormat) {
        GeneticSaveHandler.writeFormat = writeFormat;
    }

    @Override
    public CompoundNBT writeTag(IChromosome[] chromosomes, IKaryotype karyotype, CompoundNBT tagCompound) {
        return writeFormat.writeTag(chromosomes, karyotype, tagCompound);
    }

    @Override
    public IChromosome[] readTag(IKaryotype karyotype, CompoundNBT tagCompound) {
        SaveFormat format = this.getFormat(tagCompound);
        return format.readTag(karyotype, tagCompound);
    }

    private SaveFormat getFormat(CompoundNBT tagCompound) {
        for (SaveFormat format : SaveFormat.values()) {
            if (!format.canLoad(tagCompound)) continue;
            return format;
        }
        return SaveFormat.UID;
    }

    @Override
    @Nullable
    public IAllele getAlleleDirectly(CompoundNBT genomeNBT, IChromosomeType chromosomeType, boolean active) {
        SaveFormat format = this.getFormat(genomeNBT);
        return format.getAlleleDirectly(genomeNBT, chromosomeType, active);
    }

    @Override
    @Nullable
    public IAllele getAlleleDirectly(ItemStack itemStack, IOrganismType type, IChromosomeType chromosomeType, boolean active) {
        CompoundNBT nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || nbtTagCompound.isEmpty()) {
            return null;
        }
        CompoundNBT individualNBT = this.getIndividualDataDirectly(itemStack, type, chromosomeType.getRoot());
        if (individualNBT == null || individualNBT.isEmpty()) {
            return null;
        }
        CompoundNBT genomeNBT = individualNBT.func_74775_l(GENOME_TAG);
        if (genomeNBT.isEmpty()) {
            return null;
        }
        IAllele allele = this.getAlleleDirectly(genomeNBT, chromosomeType, active);
        IAlleleRegistry alleleRegistry = ApiInstance.INSTANCE.getAlleleRegistry();
        if (allele == null || !alleleRegistry.isValidAllele(allele, chromosomeType)) {
            return null;
        }
        return allele;
    }

    @Override
    public IAllele getAllele(ItemStack itemStack, IOrganismType type, IChromosomeType chromosomeType, boolean active) {
        IChromosome chromosome = this.getSpecificChromosome(itemStack, type, chromosomeType);
        return active ? chromosome.getActiveAllele() : chromosome.getInactiveAllele();
    }

    @Override
    public IChromosome getSpecificChromosome(CompoundNBT genomeNBT, IChromosomeType chromosomeType) {
        SaveFormat format = this.getFormat(genomeNBT);
        return format.getSpecificChromosome(genomeNBT, chromosomeType);
    }

    @Override
    public IChromosome getSpecificChromosome(ItemStack itemStack, IOrganismType type, IChromosomeType chromosomeType) {
        CompoundNBT nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new CompoundNBT();
            itemStack.func_77982_d(nbtTagCompound);
        }
        CompoundNBT individualNBT = this.getIndividualData(itemStack, type, chromosomeType.getRoot());
        CompoundNBT genomeNBT = individualNBT.func_74775_l(GENOME_TAG);
        return this.getSpecificChromosome(genomeNBT, chromosomeType);
    }

    @Override
    @Nullable
    public CompoundNBT getIndividualDataDirectly(ItemStack itemStack, IOrganismType type, IIndividualRoot<IIndividual> root) {
        IOrganismHandler organismHandler = GeneticHelper.getOrganismHandler(root, type);
        return organismHandler.getIndividualData(itemStack);
    }

    @Override
    public void setIndividualData(ItemStack itemStack, IOrganismType type, IIndividualRoot<IIndividual> root, CompoundNBT compound) {
        IOrganismHandler organismHandler = GeneticHelper.getOrganismHandler(root, type);
        organismHandler.setIndividualData(itemStack, compound);
    }

    @Override
    public CompoundNBT getIndividualData(ItemStack itemStack, IOrganismType type, IIndividualRoot<IIndividual> root) {
        IOrganismHandler organismHandler = GeneticHelper.getOrganismHandler(root, type);
        CompoundNBT compound = organismHandler.getIndividualData(itemStack);
        if (compound != null) {
            return compound;
        }
        compound = new CompoundNBT();
        CompoundNBT genomeNBT = compound.func_74775_l(GENOME_TAG);
        if (genomeNBT.isEmpty()) {
            Log.error("Got a genetic item with no genome, setting it to a default value.", new Object[0]);
            genomeNBT = new CompoundNBT();
            ITemplateContainer<IIndividual> container = root.getTemplates();
            IAlleleTemplate defaultTemplate = container.getKaryotype().getDefaultTemplate();
            IGenome genome = defaultTemplate.toGenome(null);
            genome.writeToNBT(genomeNBT);
            compound.func_218657_a(GENOME_TAG, (INBT)genomeNBT);
        }
        organismHandler.setIndividualData(itemStack, compound);
        return compound;
    }

    static {
        writeFormat = SaveFormat.UID;
    }
}

