/*
 * Decompiled with CFR 0.152.
 */
package genetics.organism;

import genetics.GeneticFactory;
import genetics.Genetics;
import genetics.Log;
import genetics.api.GeneticHelper;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganism;
import genetics.api.organism.IOrganismHandler;
import genetics.api.organism.IOrganismType;
import genetics.api.organism.IOrganismTypes;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class OrganismTypes<I extends IIndividual>
implements IOrganismTypes<I> {
    private final Map<IOrganismType, IOrganismHandler<I>> types = new LinkedHashMap<IOrganismType, IOrganismHandler<I>>();
    private final IIndividualRoot<I> root;
    @Nullable
    private IOrganismType defaultType;

    public OrganismTypes(IIndividualRoot<I> root) {
        this.root = root;
    }

    @Override
    public IIndividualRoot<I> getRoot() {
        return this.root;
    }

    @Override
    public IOrganismTypes<I> registerType(IOrganismType type, IOrganismHandler<I> handler, boolean defaultType) {
        this.types.put(type, handler);
        if (defaultType) {
            this.defaultType = type;
        }
        return this;
    }

    @Override
    public IOrganismTypes<I> registerType(IOrganismType type, Supplier<ItemStack> stack, boolean defaultType) {
        return this.registerType(type, GeneticFactory.INSTANCE.createOrganismHandler(this.root.getDefinition(), stack), defaultType);
    }

    @Override
    public ItemStack createStack(I individual, IOrganismType type) {
        IOrganismHandler<I> handler = this.types.get(type);
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        return handler.createStack(individual);
    }

    @Override
    public Optional<I> createIndividual(ItemStack itemStack) {
        Optional<IOrganismType> optional = this.getType(itemStack);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        IOrganismHandler<I> handler = this.types.get(optional.get());
        if (handler == null) {
            return Optional.empty();
        }
        return handler.createIndividual(itemStack);
    }

    @Override
    public boolean setIndividual(ItemStack itemStack, I individual) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        Optional<IOrganismType> optional = this.getType(itemStack);
        if (!optional.isPresent()) {
            return false;
        }
        IOrganismHandler<I> handler = this.types.get(optional.get());
        if (handler == null) {
            return false;
        }
        return handler.setIndividual(itemStack, individual);
    }

    @Override
    public Optional<IOrganismType> getType(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return Optional.empty();
        }
        IOrganism organism = (IOrganism)itemStack.getCapability(Genetics.ORGANISM).orElse(GeneticHelper.EMPTY);
        IOrganismType type = organism.getType();
        return type.isEmpty() ? Optional.empty() : this.getHandler(type).map(handler -> type);
    }

    @Override
    public IOrganismType getDefaultType() {
        if (this.defaultType == null) {
            Iterator<IOrganismType> organismTypes = this.types.keySet().iterator();
            if (!organismTypes.hasNext()) {
                String message = String.format("No types were registered for the individual root '%s'.", this.root.getUID());
                throw new IllegalStateException(message);
            }
            this.defaultType = organismTypes.next();
            Log.debug("No default type was registered for individual root '{}' used first registered type.", this.root.getUID());
        }
        return this.defaultType;
    }

    @Override
    public Optional<IOrganismHandler<I>> getHandler(IOrganismType type) {
        return Optional.ofNullable(this.types.get(type));
    }

    @Override
    public Optional<IOrganismHandler<I>> getHandler(ItemStack itemStack) {
        Optional<IOrganismType> type = this.getType(itemStack);
        return type.flatMap(this::getHandler);
    }

    @Override
    public Collection<IOrganismType> getTypes() {
        return this.types.keySet();
    }

    @Override
    public Collection<IOrganismHandler<I>> getHandlers() {
        return this.types.values();
    }

    @Override
    public ComponentKey<IOrganismTypes> getKey() {
        return ComponentKeys.TYPES;
    }
}

