/*
 * Decompiled with CFR 0.152.
 */
package genetics.parser;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Queues;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import genetics.api.GeneticsResourceType;
import genetics.api.alleles.AlleleInfo;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleType;
import genetics.utils.NBTUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.commons.io.IOUtils;

public class GeneticParser
implements ISelectiveResourceReloadListener {
    public final Map<ResourceLocation, IAlleleType> types = new HashMap<ResourceLocation, IAlleleType>();
    public static final int PATH_PREFIX_LENGTH = "genetics/alleles/".length();
    public static final int PATH_SUFFIX_LENGTH = ".json".length();
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final Deque<ResourceLocation> loadingAlleles = Queues.newArrayDeque();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> resourcePredicate) {
        if (!resourcePredicate.test(GeneticsResourceType.MUTATIONS)) {
            return;
        }
        HashMultimap alleleData = HashMultimap.create();
        for (ResourceLocation location : manager.func_199003_a("genetics/alleles", filename -> filename.endsWith(".json"))) {
            String path = location.func_110623_a();
            ResourceLocation readableLocation = new ResourceLocation(location.func_110624_b(), path.substring(PATH_PREFIX_LENGTH, path.length() - PATH_SUFFIX_LENGTH));
            try {
                IResource resource = manager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    for (ResourceLocation loading : loadingAlleles) {
                        if (location.getClass() != loading.getClass() || location.equals((Object)loading)) continue;
                    }
                    loadingAlleles.addLast(location);
                    JsonObject object = (JsonObject)JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)resource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (object == null) continue;
                    alleleData.put((Object)location, (Object)JsonToNBT.func_180713_a((String)object.toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (CommandSyntaxException popLoc) {
            }
            catch (JsonParseException | IllegalArgumentException popLoc) {
            }
            catch (IOException popLoc) {
            }
            finally {
                ResourceLocation popLoc = loadingAlleles.removeLast();
                if (popLoc == location) continue;
            }
        }
        Iterator iterator = alleleData.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation location;
            location = (ResourceLocation)iterator.next();
            CompoundNBT compound = new CompoundNBT();
            LinkedList compounds = new LinkedList(alleleData.get((Object)location));
            if (compounds.size() > 1) {
                compounds.stream().filter(tag -> tag.func_74767_n("replace")).max(Comparator.comparingInt(a -> a.func_74762_e("weight"))).ifPresent(arg_0 -> ((CompoundNBT)compound).func_197643_a(arg_0));
            }
            if (compounds.size() > 1) {
                compounds.stream().sorted(Comparator.comparingInt(a -> -a.func_74762_e("weight"))).forEach(arg_0 -> ((CompoundNBT)compound).func_197643_a(arg_0));
            }
            AlleleInfo info = new AlleleInfo(location, compound);
            info.parent = NBTUtils.getString(compound, "parent", "");
            info.dominant = NBTUtils.getBoolean(compound, "dominant", false);
            info.weight = NBTUtils.getInt(compound, "weight", 0);
            info.replace = NBTUtils.getBoolean(compound, "replace", false);
            info.replaced = info.replace && compounds.size() > 1;
            info.type = NBTUtils.getString(compound, "type");
            info.name = NBTUtils.getString(compound, "name");
            this.deserialize(info);
        }
        return;
    }

    public IAllele deserialize(AlleleInfo info) {
        ResourceLocation typeName = new ResourceLocation(info.type);
        IAlleleType type = this.types.get(typeName);
        if (type == null) {
            throw new IllegalStateException("Failed to find the allele type for the id (" + typeName + ").");
        }
        return type.deserialize(info);
    }
}

