/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IDisplayHelper;
import genetics.api.root.IIndividualRoot;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class DisplayHelper<I extends IIndividual>
implements IDisplayHelper<I> {
    private final IIndividualRoot<I> root;
    private final Table<IOrganismType, String, ItemStack> iconStacks = HashBasedTable.create();

    public DisplayHelper(IIndividualRoot<I> root) {
        this.root = root;
    }

    @Override
    public String getLocalizedShortName(IChromosomeType chromosomeType) {
        return I18n.func_135052_a((String)this.getTranslationKeyShort(chromosomeType), (Object[])new Object[0]);
    }

    @Override
    public String getTranslationKeyShort(IChromosomeType chromosomeType) {
        return "chromosome." + chromosomeType.getName() + ".short";
    }

    @Override
    public String getLocalizedName(IChromosomeType chromosomeType) {
        return I18n.func_135052_a((String)this.getTranslationKey(chromosomeType), (Object[])new Object[0]);
    }

    @Override
    public String getTranslationKey(IChromosomeType chromosomeType) {
        return "chromosome." + chromosomeType.getName();
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species, IOrganismType type) {
        String registryName = species.getRegistryName().toString();
        ItemStack stack = (ItemStack)this.iconStacks.get((Object)type, (Object)registryName);
        if (stack == null) {
            stack = this.root.createStack(species, type);
            this.iconStacks.put((Object)type, (Object)registryName, (Object)stack);
        }
        return stack;
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species) {
        return this.getDisplayStack(species, this.root.getTypes().getDefaultType());
    }
}

