/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.restrictions.Restriction;
import jeresources.api.util.BiomeHelper;
import net.minecraft.world.biome.Biome;

public class BiomeRestriction {
    public static final BiomeRestriction NO_RESTRICTION = new BiomeRestriction();
    public static final BiomeRestriction NONE = new BiomeRestriction(Biome.Category.NONE, new Biome.Category[0]);
    public static final BiomeRestriction TAIGA = new BiomeRestriction(Biome.Category.TAIGA, new Biome.Category[0]);
    public static final BiomeRestriction EXTREME_HILLS = new BiomeRestriction(Biome.Category.EXTREME_HILLS, new Biome.Category[0]);
    public static final BiomeRestriction JUNGLE = new BiomeRestriction(Biome.Category.JUNGLE, new Biome.Category[0]);
    public static final BiomeRestriction MESA = new BiomeRestriction(Biome.Category.MESA, new Biome.Category[0]);
    public static final BiomeRestriction PLAINS = new BiomeRestriction(Biome.Category.PLAINS, new Biome.Category[0]);
    public static final BiomeRestriction SAVANNA = new BiomeRestriction(Biome.Category.SAVANNA, new Biome.Category[0]);
    public static final BiomeRestriction ICY = new BiomeRestriction(Biome.Category.ICY, new Biome.Category[0]);
    public static final BiomeRestriction THEEND = new BiomeRestriction(Biome.Category.THEEND, new Biome.Category[0]);
    public static final BiomeRestriction BEACH = new BiomeRestriction(Biome.Category.BEACH, new Biome.Category[0]);
    public static final BiomeRestriction FOREST = new BiomeRestriction(Biome.Category.FOREST, new Biome.Category[0]);
    public static final BiomeRestriction OCEAN = new BiomeRestriction(Biome.Category.OCEAN, new Biome.Category[0]);
    public static final BiomeRestriction DESERT = new BiomeRestriction(Biome.Category.DESERT, new Biome.Category[0]);
    public static final BiomeRestriction RIVER = new BiomeRestriction(Biome.Category.RIVER, new Biome.Category[0]);
    public static final BiomeRestriction SWAMP = new BiomeRestriction(Biome.Category.SWAMP, new Biome.Category[0]);
    public static final BiomeRestriction MUSHROOM = new BiomeRestriction(Biome.Category.MUSHROOM, new Biome.Category[0]);
    public static final BiomeRestriction NETHER = new BiomeRestriction(Biome.Category.NETHER, new Biome.Category[0]);
    private List<Biome> biomes = new ArrayList<Biome>();
    private Restriction.Type restrictionType;

    public BiomeRestriction() {
        this.restrictionType = Restriction.Type.NONE;
    }

    public BiomeRestriction(Biome biome) {
        this(Restriction.Type.WHITELIST, biome);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome biome) {
        this(restrictionType, biome, new Biome[0]);
    }

    public BiomeRestriction(Biome biome, Biome ... moreBiomes) {
        this(Restriction.Type.WHITELIST, biome, moreBiomes);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome biome, Biome ... moreBiomes) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes.add(biome);
                this.biomes.addAll(Arrays.asList(moreBiomes));
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.remove(biome);
                this.biomes.removeAll(Arrays.asList(moreBiomes));
            }
        }
    }

    public BiomeRestriction(Biome.Category biomeCategory, Biome.Category ... biomeCategories) {
        this(Restriction.Type.WHITELIST, biomeCategory, biomeCategories);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome.Category biomeCategory, Biome.Category ... biomeCategories) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes = this.getBiomes(biomeCategory, biomeCategories);
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.removeAll(this.getBiomes(biomeCategory, biomeCategories));
            }
        }
    }

    private ArrayList<Biome> getBiomes(Biome.Category biomeCategory, Biome.Category ... biomeCategories) {
        ArrayList<Object> biomes = new ArrayList<Biome>();
        biomes.addAll(BiomeHelper.getBiomes(biomeCategory));
        for (int i = 1; i < biomeCategories.length; ++i) {
            ArrayList<Biome> newBiomes = new ArrayList<Biome>();
            for (Biome biome : BiomeHelper.getBiomes(biomeCategories[i])) {
                if (!biomes.remove(biome)) continue;
                newBiomes.add(biome);
            }
            biomes = newBiomes;
        }
        return biomes;
    }

    public List<String> toStringList() {
        return this.biomes.stream().filter(biome -> !biome.toString().equals("")).map(biome -> "  " + biome.toString()).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeRestriction) {
            BiomeRestriction other = (BiomeRestriction)obj;
            return other.biomes.size() == this.biomes.size() && other.biomes.containsAll(this.biomes);
        }
        return false;
    }

    public boolean isMergeAble(BiomeRestriction other) {
        return other.restrictionType == Restriction.Type.NONE || this.restrictionType != Restriction.Type.NONE && !this.biomes.isEmpty() && other.biomes.containsAll(this.biomes);
    }

    public String toString() {
        return "Biomes: " + (Object)((Object)this.restrictionType) + (this.restrictionType != Restriction.Type.NONE ? " - " + this.biomes.size() : "");
    }

    public int hashCode() {
        return this.restrictionType.hashCode() ^ this.biomes.hashCode();
    }
}

