/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundingRecipeBuilder {
    private final IRecipeSerializer<?> serializer;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Item resultItem;
    private final int resultCount;
    private DataResource<IMaterial> resultMaterial;

    public CompoundingRecipeBuilder(IRecipeSerializer<?> serializer, Item resultItem, int count) {
        this.serializer = serializer;
        this.resultItem = resultItem;
        this.resultCount = count;
    }

    public static CompoundingRecipeBuilder metalBuilder(IItemProvider result, int count) {
        return new CompoundingRecipeBuilder((IRecipeSerializer)ModRecipes.COMPOUNDING_METAL.get(), result.func_199767_j(), count);
    }

    public static CompoundingRecipeBuilder gemBuilder(IItemProvider result, int count) {
        return new CompoundingRecipeBuilder((IRecipeSerializer)ModRecipes.COMPOUNDING_GEM.get(), result.func_199767_j(), count);
    }

    public CompoundingRecipeBuilder withCustomMaterial(DataResource<IMaterial> material) {
        this.resultMaterial = material;
        return this;
    }

    public CompoundingRecipeBuilder addIngredient(IItemProvider item) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public CompoundingRecipeBuilder addIngredient(IItemProvider item, int count) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), count);
    }

    public CompoundingRecipeBuilder addIngredient(ITag<Item> tag) {
        return this.addIngredient(Ingredient.func_199805_a(tag));
    }

    public CompoundingRecipeBuilder addIngredient(ITag<Item> tag, int count) {
        return this.addIngredient(Ingredient.func_199805_a(tag), count);
    }

    public CompoundingRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public CompoundingRecipeBuilder addIngredient(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        String name = NameUtils.from((IForgeRegistryEntry)this.resultItem).func_110623_a();
        if (this.resultMaterial != null) {
            name = name + "." + this.resultMaterial.getId().func_110623_a();
        }
        this.build(consumer, new ResourceLocation(this.serializer.getRegistryName() + "/" + name));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation recipeId) {
        consumer.accept(new Result(recipeId));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation recipeId;

        public Result(ResourceLocation recipeId) {
            this.recipeId = recipeId;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredients", (JsonElement)this.serializeIngredients());
            json.add("result", (JsonElement)this.serializeResult());
        }

        private JsonArray serializeIngredients() {
            JsonArray ret = new JsonArray();
            for (Ingredient ingredient : CompoundingRecipeBuilder.this.ingredients) {
                ret.add(ingredient.func_200304_c());
            }
            return ret;
        }

        private JsonObject serializeResult() {
            JsonObject ret = new JsonObject();
            ret.addProperty("item", NameUtils.from((IForgeRegistryEntry)CompoundingRecipeBuilder.this.resultItem).toString());
            if (CompoundingRecipeBuilder.this.resultCount > 1) {
                ret.addProperty("count", (Number)CompoundingRecipeBuilder.this.resultCount);
            }
            if (CompoundingRecipeBuilder.this.resultMaterial != null) {
                ret.addProperty("material", CompoundingRecipeBuilder.this.resultMaterial.getId().toString());
            }
            return ret;
        }

        public ResourceLocation func_200442_b() {
            return this.recipeId;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return CompoundingRecipeBuilder.this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

