/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.Tags;

public class NetherwoodTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public NetherwoodTreeFeature(Codec<BaseTreeFeatureConfig> codec) {
        super(codec);
    }

    public static boolean isFree(IWorldGenerationBaseReader p_236410_0_, BlockPos p_236410_1_) {
        return NetherwoodTreeFeature.isReplaceableAt(p_236410_0_, p_236410_1_) || p_236410_0_.func_217375_a(p_236410_1_, p_236417_0_ -> p_236417_0_.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isVine(IWorldGenerationBaseReader p_236414_0_, BlockPos p_236414_1_) {
        return p_236414_0_.func_217375_a(p_236414_1_, p_236415_0_ -> p_236415_0_.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean isWaterAt(IWorldGenerationBaseReader p_236416_0_, BlockPos p_236416_1_) {
        return p_236416_0_.func_217375_a(p_236416_1_, p_236413_0_ -> p_236413_0_.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader p_236412_0_, BlockPos p_236412_1_) {
        return p_236412_0_.func_217375_a(p_236412_1_, p_236411_0_ -> p_236411_0_.func_196958_f() || p_236411_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isDirtOrFarmlandAt(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return state.func_235714_a_((ITag)Tags.Blocks.DIRT) || state.func_235714_a_((ITag)Tags.Blocks.NETHERRACK) || block == Blocks.field_150458_ak;
        });
    }

    private static boolean isTallPlantAt(IWorldGenerationBaseReader p_236419_0_, BlockPos p_236419_1_) {
        return p_236419_0_.func_217375_a(p_236419_1_, p_236406_0_ -> {
            Material material = p_236406_0_.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static void setBlockKnownShape(IWorldWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.func_180501_a(p_236408_1_, p_236408_2_, 19);
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader p_236404_0_, BlockPos p_236404_1_) {
        return NetherwoodTreeFeature.isAirOrLeavesAt(p_236404_0_, p_236404_1_) || NetherwoodTreeFeature.isTallPlantAt(p_236404_0_, p_236404_1_) || NetherwoodTreeFeature.isWaterAt(p_236404_0_, p_236404_1_);
    }

    private boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBoxIn, BaseTreeFeatureConfig configIn) {
        BlockPos blockpos;
        int i = configIn.field_236678_g_.func_236917_a_(rand);
        int j = configIn.field_236677_f_.func_230374_a_(rand, i, configIn);
        int k = i - j;
        int l = configIn.field_236677_f_.func_230376_a_(rand, k);
        if (!configIn.field_227372_q_) {
            int i1 = generationReader.func_205770_a(Heightmap.Type.OCEAN_FLOOR, positionIn).func_177956_o();
            int j1 = generationReader.func_205770_a(Heightmap.Type.WORLD_SURFACE, positionIn).func_177956_o();
            if (j1 - i1 > configIn.field_236680_i_) {
                return false;
            }
            int k1 = configIn.field_236682_l_ == Heightmap.Type.OCEAN_FLOOR ? i1 : (configIn.field_236682_l_ == Heightmap.Type.WORLD_SURFACE ? j1 : generationReader.func_205770_a(configIn.field_236682_l_, positionIn).func_177956_o());
            blockpos = new BlockPos(positionIn.func_177958_n(), k1, positionIn.func_177952_p());
        } else {
            blockpos = positionIn;
        }
        for (int y = 96; y >= 32; --y) {
            BlockPos pos1 = new BlockPos(blockpos.func_177958_n(), y, blockpos.func_177952_p());
            if (pos1.func_177956_o() < 1 || pos1.func_177956_o() + i + 1 > 256 || !NetherwoodTreeFeature.isDirtOrFarmlandAt((IWorldGenerationBaseReader)generationReader, pos1.func_177979_c(y))) continue;
            OptionalInt optionalint = configIn.field_236679_h_.func_236710_c_();
            int l1 = this.getMaxFreeTreeHeight((IWorldGenerationBaseReader)generationReader, i, pos1, configIn);
            if (l1 < i && (!optionalint.isPresent() || l1 < optionalint.getAsInt())) continue;
            List list = configIn.field_236678_g_.func_230382_a_(generationReader, rand, l1, pos1, p_225557_4_, boundingBoxIn, configIn);
            list.forEach(p_236407_8_ -> configIn.field_236677_f_.func_236752_a_(generationReader, rand, configIn, l1, p_236407_8_, j, l, p_225557_5_, boundingBoxIn));
            return true;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(IWorldGenerationBaseReader worldIn, int p_241521_2_, BlockPos pos, BaseTreeFeatureConfig config) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= p_241521_2_ + 1; ++i) {
            int j = config.field_236679_h_.func_230369_a_(p_241521_2_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.func_239621_a_((Vector3i)pos, k, i, l);
                    if (NetherwoodTreeFeature.isFree(worldIn, (BlockPos)blockpos$mutable) && (config.field_236681_j_ || !NetherwoodTreeFeature.isVine(worldIn, (BlockPos)blockpos$mutable))) continue;
                    return i - 2;
                }
            }
        }
        return p_241521_2_;
    }

    protected void func_230367_a_(IWorldWriter world, BlockPos pos, BlockState state) {
        NetherwoodTreeFeature.setBlockKnownShape(world, pos, state);
    }

    public boolean place(ISeedReader p_241855_1_, ChunkGenerator p_241855_2_, Random p_241855_3_, BlockPos p_241855_4_, BaseTreeFeatureConfig p_241855_5_) {
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place((IWorldGenerationReader)p_241855_1_, p_241855_3_, p_241855_4_, set, set1, mutableboundingbox, p_241855_5_);
        if (mutableboundingbox.field_78897_a <= mutableboundingbox.field_78893_d && flag && !set.isEmpty()) {
            if (!p_241855_5_.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list1.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                p_241855_5_.field_227370_o_.forEach(p_236405_6_ -> p_236405_6_.func_225576_a_(p_241855_1_, p_241855_3_, list, list1, set2, mutableboundingbox));
            }
            VoxelShapePart voxelshapepart = this.updateLeaves((IWorld)p_241855_1_, mutableboundingbox, set, set2);
            Template.func_222857_a((IWorld)p_241855_1_, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            return true;
        }
        return false;
    }

    private VoxelShapePart updateLeaves(IWorld p_236403_1_, MutableBoundingBox p_236403_2_, Set<BlockPos> p_236403_3_, Set<BlockPos> p_236403_4_) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(p_236403_2_.func_78883_b(), p_236403_2_.func_78882_c(), p_236403_2_.func_78880_d());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : Lists.newArrayList(p_236403_4_)) {
            if (!p_236403_2_.func_175898_b((Vector3i)blockpos)) continue;
            voxelshapepart.func_199625_a(blockpos.func_177958_n() - p_236403_2_.field_78897_a, blockpos.func_177956_o() - p_236403_2_.field_78895_b, blockpos.func_177952_p() - p_236403_2_.field_78896_c, true, true);
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_236403_3_)) {
            if (p_236403_2_.func_175898_b((Vector3i)blockpos1)) {
                voxelshapepart.func_199625_a(blockpos1.func_177958_n() - p_236403_2_.field_78897_a, blockpos1.func_177956_o() - p_236403_2_.field_78895_b, blockpos1.func_177952_p() - p_236403_2_.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.func_239622_a_((Vector3i)blockpos1, direction);
                if (p_236403_3_.contains(blockpos$mutable) || !(blockstate = p_236403_1_.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.func_185334_h());
                NetherwoodTreeFeature.setBlockKnownShape((IWorldWriter)p_236403_1_, (BlockPos)blockpos$mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!p_236403_2_.func_175898_b((Vector3i)blockpos$mutable)) continue;
                voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - p_236403_2_.field_78897_a, blockpos$mutable.func_177956_o() - p_236403_2_.field_78895_b, blockpos$mutable.func_177952_p() - p_236403_2_.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_236403_2_.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - p_236403_2_.field_78897_a, blockpos2.func_177956_o() - p_236403_2_.field_78895_b, blockpos2.func_177952_p() - p_236403_2_.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = p_236403_1_.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    NetherwoodTreeFeature.setBlockKnownShape((IWorldWriter)p_236403_1_, (BlockPos)blockpos$mutable, blockstate2);
                    if (p_236403_2_.func_175898_b((Vector3i)blockpos$mutable)) {
                        voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - p_236403_2_.field_78897_a, blockpos$mutable.func_177956_o() - p_236403_2_.field_78895_b, blockpos$mutable.func_177952_p() - p_236403_2_.field_78896_c, true, true);
                    }
                    set1.add(blockpos$mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }
}

