/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class HarvestCraftAddon {
    private boolean cuttingBoardFound;

    public HarvestCraftAddon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Compat.cuttingBoardItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("pamhc2foodcore", "cuttingboarditem"));
        if (Compat.cuttingBoardItem != null && Compat.cuttingBoardItem != Items.field_190931_a) {
            CookingForBlockheads.extraItemGroupItems.add((Object)new ItemStack((IItemProvider)Compat.cuttingBoardItem));
            this.cuttingBoardFound = true;
        }
    }

    public static boolean isWeirdConversionRecipe(IRecipe<?> recipe) {
        if (recipe.func_192400_c().size() == 2 && recipe.func_77571_b().func_190916_E() == 2) {
            Ingredient first = (Ingredient)recipe.func_192400_c().get(0);
            Ingredient second = (Ingredient)recipe.func_192400_c().get(1);
            return first.test(recipe.func_77571_b()) && second.test(recipe.func_77571_b());
        }
        return false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!this.cuttingBoardFound) {
            return;
        }
        if (event.getItemStack().func_77973_b() == Compat.cuttingBoardItem) {
            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:multiblock_kitchen", TextFormatting.YELLOW));
            event.getToolTip().add(new TranslationTextComponent("tooltip.cookingforblockheads:can_be_placed_in_world"));
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!this.cuttingBoardFound) {
            return;
        }
        if (event.getItemStack().func_77973_b() != Compat.cuttingBoardItem) {
            return;
        }
        if (event.getFace() != Direction.UP) {
            return;
        }
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        BlockState clickedBlock = world.func_180495_p(event.getPos());
        if (clickedBlock.func_177230_c() == Blocks.field_150486_ae || clickedBlock.func_177230_c() == Blocks.field_150462_ai || clickedBlock.func_177230_c() == ModBlocks.cuttingBoard) {
            return;
        }
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        if (this.canPlace(player, ModBlocks.cuttingBoard.func_176223_P(), world, pos)) {
            BlockItemUseContext useContext = new BlockItemUseContext(new ItemUseContext(player, event.getHand(), new BlockRayTraceResult(Vector3d.func_237491_b_((Vector3i)pos), event.getFace(), pos, true)));
            BlockState placedState = ModBlocks.cuttingBoard.func_196258_a(useContext);
            world.func_175656_a(pos, placedState);
            if (!player.field_71075_bZ.field_75098_d) {
                event.getItemStack().func_190918_g(1);
            }
            player.func_184609_a(event.getHand());
            player.func_184185_a(SoundEvents.field_187891_gV, 1.0f, 1.0f);
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    private boolean canPlace(PlayerEntity player, BlockState state, World world, BlockPos pos) {
        ISelectionContext context = ISelectionContext.func_216374_a((Entity)player);
        return state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, context);
    }
}

