/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.Logger;

public class LootConditionRegistry {
    private final String ownerId;
    private final Logger logger;
    private final Map<ResourceLocation, LootConditionType> lootConditions;

    public LootConditionRegistry(String ownerId, Logger logger) {
        this.ownerId = ownerId;
        this.logger = logger;
        this.lootConditions = new HashMap<ResourceLocation, LootConditionType>();
    }

    public void initialize(IEventBus bus) {
        if (!this.lootConditions.isEmpty()) {
            bus.addListener(this::registerCommands);
        }
    }

    public LootConditionType register(ILootSerializer<? extends ILootCondition> serializer, String id) {
        LootConditionType conditionType = new LootConditionType(serializer);
        this.lootConditions.put(new ResourceLocation(this.ownerId, id), conditionType);
        return conditionType;
    }

    private void registerCommands(FMLCommonSetupEvent event) {
        if (!this.lootConditions.isEmpty()) {
            this.logger.info("Registering {} loot conditions.", (Object)this.lootConditions.size());
            for (Map.Entry<ResourceLocation, LootConditionType> entry : this.lootConditions.entrySet()) {
                Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)entry.getKey(), (Object)entry.getValue());
                this.logger.debug("Registered Loot Condition \"{}\" with type {}.", (Object)entry.getKey(), (Object)entry.getValue().getClass().getName());
            }
        }
    }
}

