/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.ActionKey;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.items.RepoSlot;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.me.common.GridInventoryEntry;
import appeng.container.me.common.MEMonitorableContainer;
import appeng.container.me.crafting.CraftingStatusContainer;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.abstraction.JEIFacade;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class MEMonitorableScreen<T extends IAEStack<T>, C extends MEMonitorableContainer<T>>
extends AEBaseScreen<C>
implements ISortSource,
IConfigManagerHost {
    private static final int MIN_ROWS = 3;
    private static String memoryText = "";
    private final appeng.client.gui.style.TerminalStyle style;
    protected final Repo<T> repo;
    private final List<ItemStack> currentViewCells = new ArrayList<ItemStack>();
    private final IConfigManager configSrc;
    private final boolean supportsViewCells;
    private TabButton craftingStatusBtn;
    private AETextField searchField;
    private int rows = 0;
    private SettingToggleButton<ViewItems> viewModeToggle;
    private SettingToggleButton<SortOrder> sortByToggle;
    private final SettingToggleButton<SortDir> sortDirToggle;
    private boolean isAutoFocus = false;
    private int currentMouseX = 0;
    private int currentMouseY = 0;
    private final Scrollbar scrollbar;

    public MEMonitorableScreen(C container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.style = style.getTerminalStyle();
        if (this.style == null) {
            throw new IllegalStateException("Cannot construct screen " + this.getClass() + " without a terminalStyles setting");
        }
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.repo = this.createRepo(this.scrollbar);
        ((MEMonitorableContainer)container).setClientRepo(this.repo);
        this.repo.setUpdateViewListener(this::updateScrollbar);
        this.updateScrollbar();
        this.field_146999_f = this.style.getScreenWidth();
        this.field_147000_g = this.style.getScreenHeight(0);
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        ((MEMonitorableContainer)this.field_147002_h).setGui(this);
        List<Slot> viewCellSlots = ((AEBaseContainer)((Object)container)).getSlots(SlotSemantic.VIEW_CELL);
        boolean bl = this.supportsViewCells = !viewCellSlots.isEmpty();
        if (this.supportsViewCells) {
            List<ITextComponent> tooltip = Collections.singletonList(GuiText.TerminalViewCellsTooltip.text());
            this.widgets.add("viewCells", new UpgradesPanel(viewCellSlots, () -> tooltip));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.craftingStatusBtn = new TabButton(Icon.PERMISSION_CRAFT, GuiText.CraftingStatus.text(), this.field_230707_j_, btn -> this.showCraftingStatus());
            this.craftingStatusBtn.setHideEdge(true);
            this.widgets.add("craftingStatus", (Widget)this.craftingStatusBtn);
        }
        if (this.style.isSortable()) {
            this.sortByToggle = this.addToLeftToolbar(new SettingToggleButton<SortOrder>(Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.viewModeToggle = this.addToLeftToolbar(new SettingToggleButton<ViewItems>(Settings.VIEW_MODE, this.getSortDisplay(), this::toggleServerSetting));
        }
        this.sortDirToggle = new SettingToggleButton<SortDir>(Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting);
        this.addToLeftToolbar(this.sortDirToggle);
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        this.addToLeftToolbar(new SettingToggleButton<SearchBoxMode>(Settings.SEARCH_MODE, searchMode, Platform::isSearchModeAvailable, this::toggleTerminalSearchMode));
        if (this.style.getMaxRows() == null) {
            TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
            this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        }
    }

    protected abstract Repo<T> createRepo(IScrollSource var1);

    @Nullable
    protected abstract IPartitionList<T> createPartitionList(List<ItemStack> var1);

    protected abstract void renderGridInventoryEntry(MatrixStack var1, int var2, int var3, GridInventoryEntry<T> var4);

    protected abstract void handleGridInventoryEntryMouseClick(@Nullable GridInventoryEntry<T> var1, int var2, ClickType var3);

    private void updateScrollbar() {
        this.scrollbar.setHeight(this.rows * this.style.getRow().getSrcHeight() - 2);
        int totalRows = (this.repo.size() + this.getSlotsPerRow() - 1) / this.getSlotsPerRow();
        this.scrollbar.setRange(0, totalRows - this.rows, Math.max(1, this.rows / 6));
    }

    private void showCraftingStatus() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(CraftingStatusContainer.TYPE));
    }

    private int getSlotsPerRow() {
        return this.style.getSlotsPerRow();
    }

    @Override
    public void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.rows = MathHelper.func_76125_a((int)this.style.getPossibleRows(this.field_230709_l_), (int)3, (int)this.getMaxRows());
        this.field_147000_g = this.style.getScreenHeight(this.rows);
        List slots = ((MEMonitorableContainer)this.field_147002_h).field_75151_b;
        slots.removeIf(slot -> slot instanceof RepoSlot);
        int repoIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.style.getSlotsPerRow(); ++col) {
                Point pos = this.style.getSlotPos(row, col);
                slots.add(new RepoSlot<T>(this.repo, repoIndex++, pos.getX(), pos.getY()));
            }
        }
        super.func_231160_c_();
        Rectangle2d searchFieldRect = this.style.getSearchFieldRect();
        this.searchField = new AETextField(this.field_230712_o_, this.field_147003_i + searchFieldRect.func_199318_a(), this.field_147009_r + searchFieldRect.func_199319_b(), searchFieldRect.func_199316_c(), searchFieldRect.func_199317_d());
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-16744448);
        this.searchField.func_146189_e(true);
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        this.isAutoFocus = SearchBoxMode.AUTOSEARCH == searchMode || SearchBoxMode.JEI_AUTOSEARCH == searchMode || SearchBoxMode.AUTOSEARCH_KEEP == searchMode || SearchBoxMode.JEI_AUTOSEARCH_KEEP == searchMode;
        boolean isKeepFilter = SearchBoxMode.AUTOSEARCH_KEEP == searchMode || SearchBoxMode.JEI_AUTOSEARCH_KEEP == searchMode || SearchBoxMode.MANUAL_SEARCH_KEEP == searchMode || SearchBoxMode.JEI_MANUAL_SEARCH_KEEP == searchMode;
        boolean isJEIEnabled = SearchBoxMode.JEI_AUTOSEARCH == searchMode || SearchBoxMode.JEI_MANUAL_SEARCH == searchMode;
        this.searchField.func_146195_b(this.isAutoFocus);
        if (this.searchField.func_230999_j_()) {
            this.func_231035_a_((IGuiEventListener)this.searchField);
        }
        if (isJEIEnabled) {
            memoryText = JEIFacade.instance().getSearchText();
        }
        if (isKeepFilter && memoryText != null && !memoryText.isEmpty()) {
            this.searchField.func_146180_a(memoryText);
            this.searchField.selectAll();
            this.repo.setSearchString(memoryText);
            this.repo.updateView();
        }
        this.updateScrollbar();
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (!this.field_230704_d_.getString().isEmpty()) {
            this.setTextContent("dialog_title", this.field_230704_d_);
        } else if (((MEMonitorableContainer)this.field_147002_h).getTarget() instanceof IMEChest) {
            this.setTextContent("dialog_title", GuiText.Chest.text());
        }
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        if (this.craftingStatusBtn != null && ((MEMonitorableContainer)this.field_147002_h).activeCraftingJobs != -1) {
            int x = this.craftingStatusBtn.field_230690_l_ + (this.craftingStatusBtn.func_230998_h_() - 16) / 2;
            int y = this.craftingStatusBtn.field_230691_m_ + (this.craftingStatusBtn.func_238483_d_() - 16) / 2;
            this.style.getStackSizeRenderer().renderSizeLabel(this.field_230712_o_, x - this.field_147003_i, y - this.field_147009_r, String.valueOf(((MEMonitorableContainer)this.field_147002_h).activeCraftingJobs));
        }
    }

    @Override
    public boolean func_231044_a_(double xCoord, double yCoord, int btn) {
        if (this.searchField.func_231044_a_(xCoord, yCoord, btn)) {
            return true;
        }
        if (this.searchField.func_231047_b_(xCoord, yCoord) && btn == 1) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.updateScrollbar();
            return true;
        }
        return super.func_231044_a_(xCoord, yCoord, btn);
    }

    @Override
    public boolean func_231043_a_(double x, double y, double wheelDelta) {
        Slot slot;
        RepoSlot<T> repoSlot;
        if (wheelDelta != 0.0 && MEMonitorableScreen.func_231173_s_() && (repoSlot = RepoSlot.tryCast(this.repo, slot = this.getSlot((int)x, (int)y))) != null) {
            GridInventoryEntry<T> entry = repoSlot.getEntry();
            long serial = entry != null ? entry.getSerial() : -1L;
            InventoryAction direction = wheelDelta > 0.0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = (int)Math.abs(wheelDelta);
            for (int h = 0; h < times; ++h) {
                MEInteractionPacket p = new MEInteractionPacket(((MEMonitorableContainer)this.field_147002_h).field_75152_c, serial, direction);
                NetworkHandler.instance().sendToServer(p);
            }
            return true;
        }
        return super.func_231043_a_(x, y, wheelDelta);
    }

    @Override
    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        RepoSlot<T> repoSlot = RepoSlot.tryCast(this.repo, slot);
        if (repoSlot != null) {
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), mouseButton, clickType);
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
        memoryText = this.searchField.func_146179_b();
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.style.getHeader().dest(offsetX, offsetY).blit(matrixStack, this.func_230927_p_());
        int y = offsetY;
        this.style.getHeader().dest(offsetX, y).blit(matrixStack, this.func_230927_p_());
        y += this.style.getHeader().getSrcHeight();
        int rowsToDraw = Math.max(2, this.rows);
        for (int x = 0; x < rowsToDraw; ++x) {
            Blitter row = this.style.getRow();
            if (x == 0) {
                row = this.style.getFirstRow();
            } else if (x + 1 == rowsToDraw) {
                row = this.style.getLastRow();
            }
            row.dest(offsetX, y).blit(matrixStack, this.func_230927_p_());
            y += this.style.getRow().getSrcHeight();
        }
        this.style.getBottom().dest(offsetX, y).blit(matrixStack, this.func_230927_p_());
        if (this.searchField != null) {
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void func_238746_a_(MatrixStack matrices, Slot s) {
        RepoSlot<T> repoSlot = RepoSlot.tryCast(this.repo, s);
        if (repoSlot != null) {
            if (!this.repo.hasPower()) {
                MEMonitorableScreen.func_238467_a_((MatrixStack)matrices, (int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
            } else {
                GridInventoryEntry<T> entry = repoSlot.getEntry();
                if (entry != null) {
                    try {
                        this.renderGridInventoryEntry(matrices, s.field_75223_e, s.field_75221_f, entry);
                    }
                    catch (Exception err) {
                        AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
                    }
                    long storedAmount = entry.getStoredAmount();
                    boolean craftable = entry.isCraftable();
                    if (this.isViewOnlyCraftable() && craftable) {
                        this.style.getStackSizeRenderer().renderStackSize(this.field_230712_o_, 0L, true, s.field_75223_e, s.field_75221_f);
                    } else {
                        this.style.getStackSizeRenderer().renderStackSize(this.field_230712_o_, storedAmount, craftable, s.field_75223_e, s.field_75221_f);
                    }
                }
            }
            return;
        }
        super.func_238746_a_(matrices, s);
    }

    protected final boolean isViewOnlyCraftable() {
        return this.viewModeToggle != null && this.viewModeToggle.getCurrentValue() == ViewItems.CRAFTABLE;
    }

    protected void func_230459_a_(MatrixStack matrixStack, int x, int y) {
        RepoSlot<T> repoSlot;
        if ((this.style.isShowTooltipsWithItemInHand() || this.getPlayer().field_71071_by.func_70445_o().func_190926_b()) && (repoSlot = RepoSlot.tryCast(this.repo, this.field_147006_u)) != null) {
            GridInventoryEntry<T> entry = repoSlot.getEntry();
            if (entry != null) {
                this.renderGridInventoryEntryTooltip(matrixStack, entry, x, y);
            }
            return;
        }
        super.func_230459_a_(matrixStack, x, y);
    }

    protected void renderGridInventoryEntryTooltip(MatrixStack matrices, GridInventoryEntry<T> entry, int x, int y) {
        long requestableAmount;
        int bigNumber = AEConfig.instance().isUseLargeFonts() ? 999 : 9999;
        ItemStack stack = entry.getStack().asItemStackRepresentation();
        List currentToolTip = this.func_231151_a_(stack);
        long storedAmount = entry.getStoredAmount();
        if (storedAmount > (long)bigNumber || storedAmount > 1L && stack.func_77951_h()) {
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(storedAmount);
            currentToolTip.add(ButtonToolTips.ItemsStored.text(formattedAmount).func_240699_a_(TextFormatting.GRAY));
        }
        if ((requestableAmount = entry.getRequestableAmount()) > 0L) {
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(requestableAmount);
            currentToolTip.add(ButtonToolTips.ItemsRequestable.text(formattedAmount));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            currentToolTip.add(new StringTextComponent("Serial: " + entry.getSerial()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.renderWrappedToolTip(matrices, currentToolTip, x, y, this.field_230712_o_);
    }

    private int getMaxRows() {
        Integer maxRows = this.style.getMaxRows();
        if (maxRows != null) {
            return maxRows;
        }
        return AEConfig.instance().getTerminalStyle() == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    public boolean func_231042_a_(char character, int p_charTyped_2_) {
        if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
            return true;
        }
        if (this.isAutoFocus && !this.searchField.func_230999_j_() && this.isHovered()) {
            this.func_212928_a((IGuiEventListener)this.searchField);
        }
        if (this.searchField.func_230999_j_() && this.searchField.func_231042_a_(character, p_charTyped_2_)) {
            this.repo.setSearchString(this.searchField.func_146179_b());
            this.repo.updateView();
            this.updateScrollbar();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode != 256 && !this.checkHotbarKeys(input)) {
            if (AppEng.proxy.isActionKey(ActionKey.TOGGLE_FOCUS, input)) {
                this.searchField.func_146195_b(!this.searchField.func_230999_j_());
                if (this.searchField.func_230999_j_()) {
                    this.func_231035_a_((IGuiEventListener)this.searchField);
                }
                return true;
            }
            if (this.searchField.func_230999_j_()) {
                if (keyCode == 257) {
                    this.searchField.func_146195_b(false);
                    this.func_231035_a_(null);
                    return true;
                }
                if (this.searchField.func_231046_a_(keyCode, scanCode, p_keyPressed_3_)) {
                    this.repo.setSearchString(this.searchField.func_146179_b());
                    this.repo.updateView();
                    this.updateScrollbar();
                }
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    private boolean isHovered() {
        return this.func_195359_a(0, 0, this.field_146999_f, this.field_147000_g, this.currentMouseX, this.currentMouseY);
    }

    @Override
    public void func_231023_e_() {
        List<ItemStack> viewCells;
        this.repo.setPower(((MEMonitorableContainer)this.field_147002_h).isPowered());
        if (this.supportsViewCells && !this.currentViewCells.equals(viewCells = ((MEMonitorableContainer)this.field_147002_h).getViewCells())) {
            this.currentViewCells.clear();
            this.currentViewCells.addAll(viewCells);
            this.repo.setPartitionList(this.createPartitionList(viewCells));
        }
        super.func_231023_e_();
    }

    @Override
    public SortOrder getSortBy() {
        return (SortOrder)this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return (SortDir)this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return (ViewItems)this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.sortByToggle != null) {
            this.sortByToggle.set(this.getSortBy());
        }
        if (this.sortDirToggle != null) {
            this.sortDirToggle.set(this.getSortDir());
        }
        if (this.viewModeToggle != null) {
            this.viewModeToggle.set(this.getSortDisplay());
        }
        this.repo.updateView();
    }

    private void toggleTerminalSearchMode(SettingToggleButton<SearchBoxMode> btn, boolean backwards) {
        SearchBoxMode next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalSearchMode(next);
        btn.set(next);
        this.reinitalize();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitalize();
    }

    private <SE extends Enum<SE>> void toggleServerSetting(SettingToggleButton<SE> btn, boolean backwards) {
        SE next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting().name(), ((Enum)next).name()));
        btn.set(next);
    }

    private void reinitalize() {
        this.field_230705_e_.removeAll(this.field_230710_m_);
        this.field_230710_m_.clear();
        this.func_231160_c_();
    }
}

