/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.advancement;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.ResourceLocation;
import ovh.corail.recycler.advancement.ITriggerable;
import ovh.corail.recycler.advancement.StatelessCriterion;

public class AbstractTrigger
implements ICriterionTrigger<StatelessCriterion>,
ITriggerable {
    private final Map<PlayerAdvancements, Set<ICriterionTrigger.Listener<StatelessCriterion>>> listeners = Maps.newIdentityHashMap();
    private final ResourceLocation rl;
    private final BiFunction<JsonObject, ConditionArrayParser, StatelessCriterion> factory;

    public AbstractTrigger(String name) {
        this(new ResourceLocation("corail_recycler", name));
    }

    public AbstractTrigger(ResourceLocation rl) {
        this(rl, (json, parser) -> new StatelessCriterion(rl));
    }

    public AbstractTrigger(ResourceLocation rl, BiFunction<JsonObject, ConditionArrayParser, StatelessCriterion> factory) {
        this.rl = rl;
        this.factory = factory;
    }

    public ResourceLocation func_192163_a() {
        return this.rl;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<StatelessCriterion> listener) {
        this.listeners.computeIfAbsent(playerAdvancements, advancements -> Sets.newHashSet()).add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<StatelessCriterion> listener) {
        Set<ICriterionTrigger.Listener<StatelessCriterion>> set = this.listeners.get(playerAdvancements);
        if (set != null && set.remove(listener) && set.isEmpty()) {
            this.listeners.remove(playerAdvancements);
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public StatelessCriterion createInstance(JsonObject json, ConditionArrayParser context) {
        return this.factory.apply(json, context);
    }

    @Override
    public void trigger(ServerPlayerEntity player) {
        this.trigger(player, instance -> true);
    }

    public void trigger(ServerPlayerEntity player, Predicate<StatelessCriterion> predic) {
        PlayerAdvancements playeradvancements = player.func_192039_O();
        Set<ICriterionTrigger.Listener<StatelessCriterion>> set = this.listeners.get(playeradvancements);
        if (set != null && !set.isEmpty()) {
            List<ICriterionTrigger.Listener> list = set.stream().filter(l -> predic.test((StatelessCriterion)l.func_192158_a())).collect(Collectors.toList());
            list.forEach(l -> l.func_192159_a(playeradvancements));
        }
    }
}

