/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.recycler.gui.RecyclingBookMenu;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerRecyclingBookMessage;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecyclingBook
extends ContainerScreen<RecyclingBookMenu> {
    private static final ResourceLocation TEXTURE_VANILLA_RECYCLER = new ResourceLocation("corail_recycler:textures/gui/vanilla_recycler.png");
    private static final ResourceLocation TEXTURE_RECYCLING_BOOK = new ResourceLocation("corail_recycler:textures/gui/book.png");
    private ChangePageButton forwardButton;
    private ChangePageButton backButton;
    private TextFieldWidget searchBox;
    private String lastText = "";
    private final Map<Integer, Rectangle> recipeFlags = new HashMap<Integer, Rectangle>();

    public GuiRecyclingBook(RecyclingBookMenu container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 250;
        this.field_147000_g = 150;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.backButton = new ChangePageButton(this.field_147003_i + 20, this.field_147009_r + 135, false, pressable -> {
            if (((RecyclingBookMenu)this.field_147002_h).getPageNum() > 0) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((RecyclingBookMenu)this.field_147002_h).getPageNum() - 1));
            }
        }, true);
        this.func_230480_a_((Widget)this.backButton);
        this.forwardButton = new ChangePageButton(this.field_147003_i + 212, this.field_147009_r + 135, true, pressable -> {
            if (((RecyclingBookMenu)this.field_147002_h).getPageNum() < ((RecyclingBookMenu)this.field_147002_h).getPageMax()) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((RecyclingBookMenu)this.field_147002_h).getPageNum() + 1));
            }
        }, true);
        this.func_230480_a_((Widget)this.forwardButton);
        this.recipeFlags.clear();
        ((RecyclingBookMenu)this.field_147002_h).field_75151_b.stream().filter(slot -> Helper.atInterval(slot.getSlotIndex(), 10, false)).forEach(slot -> {
            int startPosX = this.field_147003_i + slot.field_75223_e;
            int startPosY = this.field_147009_r + slot.field_75221_f;
            int slotId = slot.getSlotIndex() / 10;
            this.recipeFlags.put(slotId * 3, new Rectangle(startPosX, startPosY + 16, 5, 5));
            this.recipeFlags.put(slotId * 3 + 1, new Rectangle(startPosX + 5, startPosY + 16, 5, 5));
            this.recipeFlags.put(slotId * 3 + 2, new Rectangle(startPosX + 10, startPosY + 16, 5, 5));
        });
        this.searchBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 32, this.field_147009_r + 141, 64, 12, (ITextComponent)new StringTextComponent("search"));
        this.func_230480_a_((Widget)this.searchBox);
        this.configureSearchBox();
    }

    private void configureSearchBox() {
        this.searchBox.func_146184_c(true);
        this.searchBox.func_146195_b(true);
        this.searchBox.func_146203_f(20);
        this.searchBox.func_146180_a("");
        this.searchBox.func_146205_d(false);
        this.searchBox.func_146185_a(false);
    }

    private void updateButton(int buttonNum, boolean state) {
        if (buttonNum == 0) {
            this.backButton.field_230693_o_ = this.backButton.field_230694_p_ = state;
        } else if (buttonNum == 1) {
            this.forwardButton.field_230693_o_ = this.forwardButton.field_230694_p_ = state;
        }
    }

    private void updateButtons() {
        if (((RecyclingBookMenu)this.field_147002_h).getPageNum() <= 0) {
            ((RecyclingBookMenu)this.field_147002_h).setPageNum(0);
            this.updateButton(0, false);
            this.updateButton(1, ((RecyclingBookMenu)this.field_147002_h).getPageMax() > 0);
        } else if (((RecyclingBookMenu)this.field_147002_h).getPageNum() >= ((RecyclingBookMenu)this.field_147002_h).getPageMax()) {
            ((RecyclingBookMenu)this.field_147002_h).setPageNum(((RecyclingBookMenu)this.field_147002_h).getPageMax());
            this.updateButton(0, true);
            this.updateButton(1, false);
        } else {
            this.updateButton(0, true);
            this.updateButton(1, true);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode == 256) {
            return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
        }
        if (keyCode == 259) {
            String text = this.searchBox.func_146179_b();
            if (text.length() < 2) {
                this.searchBox.func_146180_a("");
            } else {
                this.searchBox.func_146180_a(text.substring(0, text.length() - 1));
            }
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchBox.func_231042_a_(Character.toLowerCase(p_charTyped_1_), p_charTyped_2_)) {
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public void func_231023_e_() {
        String currentText;
        super.func_231023_e_();
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && Helper.atInterval(world.func_82737_E(), 10) && !this.lastText.equals(currentText = this.searchBox.func_146179_b())) {
            this.lastText = currentText;
            PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.SEARCH_TEXT, this.searchBox.func_146179_b().toLowerCase(Locale.US)));
        }
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(poseStack, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_230450_a_(MatrixStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.updateButtons();
        this.func_230446_a_(poseStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_RECYCLING_BOOK);
        GuiRecyclingBook.func_238463_a_((MatrixStack)poseStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)256, (int)158, (int)256, (int)158);
        GuiRecyclingBook.func_238467_a_((MatrixStack)poseStack, (int)(this.searchBox.field_230690_l_ - 4), (int)(this.searchBox.field_230691_m_ - 3), (int)(this.searchBox.field_230690_l_ + this.searchBox.func_230998_h_() + 7), (int)(this.searchBox.field_230691_m_ + this.searchBox.func_238483_d_() - 1), (int)-7968700);
        GuiRecyclingBook.func_238467_a_((MatrixStack)poseStack, (int)(this.searchBox.field_230690_l_ - 3), (int)(this.searchBox.field_230691_m_ - 2), (int)(this.searchBox.field_230690_l_ + this.searchBox.func_230998_h_() + 6), (int)(this.searchBox.field_230691_m_ + this.searchBox.func_238483_d_() - 2), (int)-16777216);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_VANILLA_RECYCLER);
        for (Slot slot : ((RecyclingBookMenu)this.field_147002_h).field_75151_b) {
            int recipeId;
            int startPosX = this.field_147003_i + slot.field_75223_e;
            int startPosY = this.field_147009_r + slot.field_75221_f;
            this.func_238474_b_(poseStack, startPosX, startPosY, 112, 222, 16, 16);
            if (!Helper.atInterval(slot.getSlotIndex(), 10, false) || !((RecyclingBookMenu)this.field_147002_h).isUserDefinedRecipe(recipeId = slot.getSlotIndex() / 10)) continue;
            Rectangle pos = this.recipeFlags.get(recipeId * 3);
            GuiRecyclingBook.func_238467_a_((MatrixStack)poseStack, (int)pos.x, (int)pos.y, (int)(pos.x + pos.width), (int)(pos.y + pos.height), (int)-16776961);
        }
    }

    protected void func_230459_a_(MatrixStack poseStack, int mouseX, int mouseY) {
        this.recipeFlags.entrySet().stream().filter(p -> ((Rectangle)p.getValue()).contains(mouseX, mouseY)).findFirst().ifPresent(entry -> {
            int recipeId = (Integer)entry.getKey() / 3;
            boolean valid = ((RecyclingBookMenu)this.field_147002_h).isUserDefinedRecipe(recipeId);
            if (valid) {
                this.func_238652_a_(poseStack, (ITextComponent)new StringTextComponent("user defined"), mouseX, mouseY);
            }
        });
        super.func_230459_a_(poseStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack poseStack, int mouseX, int mouseY) {
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        float revScale = 2.0f;
        ((RecyclingBookMenu)this.field_147002_h).field_75151_b.stream().filter(p -> Helper.atInterval(p.getSlotIndex(), 10, false) && !p.func_75211_c().func_190926_b()).forEach(slot -> {
            String text = TextFormatting.BOLD + slot.func_75211_c().func_151000_E().getString();
            this.field_230712_o_.func_238421_b_(poseStack, text, ((float)slot.field_75223_e + 45.5f) * revScale - (float)this.field_230712_o_.func_78256_a(text) / 2.0f, (float)(slot.field_75221_f - 24) * revScale, -10860534);
        });
        String pageMessage = ((RecyclingBookMenu)this.field_147002_h).getPageNum() + 1 + "/" + (((RecyclingBookMenu)this.field_147002_h).getPageMax() + 1);
        this.field_230712_o_.func_238421_b_(poseStack, pageMessage, (float)(this.field_146999_f - 50) * revScale - (float)this.field_230712_o_.func_78256_a(pageMessage), 141.0f * revScale, -10860534);
        poseStack.func_227865_b_();
        GuiRecyclingBook.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)LangKey.MESSAGE_RECYCLING_BOOK.getText(TextFormatting.BOLD), (int)(this.field_146999_f / 2), (int)-10, (int)-2838729);
    }

    private static class Rectangle {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        private Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        private boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }
}

