/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.recycler.gui.RecyclingBookMenu;
import ovh.corail.recycler.helper.Helper;

public class ServerRecyclingBookMessage {
    private final RecyclingBookAction action;
    private int pageNum;
    private String searchText;

    public ServerRecyclingBookMessage(RecyclingBookAction action, int pageNum) {
        this.action = action;
        if (this.action == RecyclingBookAction.CHANGE_PAGE) {
            this.pageNum = pageNum;
        }
    }

    public ServerRecyclingBookMessage(RecyclingBookAction action, String searchText) {
        this.action = action;
        if (this.action == RecyclingBookAction.SEARCH_TEXT) {
            this.searchText = searchText;
        }
    }

    static ServerRecyclingBookMessage fromBytes(PacketBuffer buf) {
        RecyclingBookAction currentAction = RecyclingBookAction.values()[buf.readShort()];
        if (currentAction == RecyclingBookAction.CHANGE_PAGE) {
            return new ServerRecyclingBookMessage(currentAction, buf.readInt());
        }
        return new ServerRecyclingBookMessage(currentAction, buf.func_150789_c(20));
    }

    static void toBytes(ServerRecyclingBookMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        if (msg.action == RecyclingBookAction.CHANGE_PAGE) {
            buf.writeInt(msg.pageNum);
        } else {
            buf.func_180714_a(msg.searchText);
        }
    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclingBookMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null && player.field_71070_bA instanceof RecyclingBookMenu) {
                        if (message.action == RecyclingBookAction.CHANGE_PAGE) {
                            ((RecyclingBookMenu)player.field_71070_bA).initPage(message.pageNum);
                        } else {
                            ((RecyclingBookMenu)player.field_71070_bA).updateSearchText(message.searchText);
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum RecyclingBookAction {
        CHANGE_PAGE,
        SEARCH_TEXT;

    }
}

