/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;

public class UpdateConfigMessage {
    public final boolean allow_automation;
    public final boolean permanent_discover_button;

    public UpdateConfigMessage(boolean allow_automation, boolean permanent_discover_button) {
        this.allow_automation = allow_automation;
        this.permanent_discover_button = permanent_discover_button;
    }

    static UpdateConfigMessage fromBytes(PacketBuffer buf) {
        return new UpdateConfigMessage(buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateConfigMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.allow_automation);
        buf.writeBoolean(msg.permanent_discover_button);
    }

    static class Handler {
        Handler() {
        }

        static void handle(UpdateConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ConfigRecycler.updateConfig(message));
            }
            ctx.setPacketHandled(true);
        }
    }
}

