/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.item.CanisterItem;

public class FluidCanisterWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    @Nonnull
    protected ItemStack container;

    public FluidCanisterWrapper(@Nonnull ItemStack container) {
        this.container = container;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Nonnull
    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        if (item instanceof CanisterItem) {
            return new FluidStack(((CanisterItem)item).getFluid(this.container), this.container.func_190916_E() * 1000);
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(@Nonnull FluidStack fluidStack) {
        this.container = fluidStack.isEmpty() ? new ItemStack(ModItems.CANISTER, this.container.func_190916_E()) : CanisterItem.getStack(fluidStack.getFluid(), this.container.func_190916_E());
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.container.func_190916_E() * 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getAmount() < this.container.func_190916_E() * 1000 || !this.getFluid().isEmpty()) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return this.container.func_190916_E() * 1000;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getAmount() < this.container.func_190916_E() * 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain < this.container.func_190916_E() * 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }
}

