/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.api.crafting.recipe.fluid;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidInventory;

public interface IFluidRecipe<C extends IFluidInventory>
extends IRecipe<C> {
    public List<FluidStack> getFluidResults(C var1);

    public List<FluidStack> getFluidOutputs();

    public List<FluidIngredient> getFluidIngredients();

    default public ItemStack getCraftingResult(C inv) {
        return this.func_77571_b();
    }

    default public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    default public boolean func_194133_a(int width, int height) {
        return true;
    }

    public static FluidStack deserializeFluid(JsonObject json) {
        ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
        int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid: " + fluidId);
        }
        return new FluidStack(fluid, amount);
    }

    public static FluidStack readFluid(PacketBuffer buffer) {
        ResourceLocation fluidId = buffer.func_192575_l();
        int amount = buffer.func_150792_a();
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (fluid != null) {
            return new FluidStack(fluid, amount);
        }
        SilentMechanisms.LOGGER.error("Unknown fluid: {}", (Object)fluidId);
        return FluidStack.EMPTY;
    }

    public static void writeFluid(PacketBuffer buffer, FluidStack stack) {
        buffer.func_192572_a(Objects.requireNonNull(stack.getFluid().getRegistryName()));
        buffer.func_150787_b(stack.getAmount());
    }
}

