/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractEnergyInventoryTileEntity;
import net.silentchaos512.mechanisms.item.MachineUpgradeItem;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.utils.EnumUtils;

public abstract class AbstractMachineBaseTileEntity
extends AbstractEnergyInventoryTileEntity {
    public static final int FIELDS_COUNT = 5;
    protected final MachineTier tier;
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORED;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractMachineBaseTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractMachineBaseTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractMachineBaseTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractMachineBaseTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return AbstractMachineBaseTileEntity.this.redstoneMode.ordinal();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    AbstractMachineBaseTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };

    protected AbstractMachineBaseTileEntity(TileEntityType<?> typeIn, int inventorySize, int maxEnergy, int maxReceive, int maxExtract, MachineTier tier) {
        super(typeIn, inventorySize + tier.getUpgradeSlots(), maxEnergy, maxReceive, maxExtract);
        this.tier = tier;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    public MachineTier getMachineTier() {
        return this.tier;
    }

    public int getUpgradeCount(IItemProvider upgradeItem) {
        int count = 0;
        for (int i = this.func_70302_i_() - this.tier.getUpgradeSlots(); i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != upgradeItem.func_199767_j()) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    protected float getUpgradesEnergyMultiplier() {
        float cost = 1.0f;
        for (int i = this.func_70302_i_() - this.tier.getUpgradeSlots(); i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof MachineUpgradeItem)) continue;
            cost += (float)stack.func_190916_E() * ((MachineUpgradeItem)stack.func_77973_b()).getUpgrade().getEnergyUsageMultiplier();
        }
        return cost;
    }

    @Override
    public IIntArray getFields() {
        return this.fields;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)tags.func_74771_c("RedstoneMode"), (Enum)RedstoneMode.IGNORED);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        tags.func_74774_a("RedstoneMode", (byte)this.redstoneMode.ordinal());
        return tags;
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)tags.func_74771_c("RedstoneMode"), (Enum)RedstoneMode.IGNORED);
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        tags.func_74774_a("RedstoneMode", (byte)this.redstoneMode.ordinal());
        return tags;
    }
}

