/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.pipe;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.mechanisms.api.ConnectionType;
import net.silentchaos512.mechanisms.block.pipe.PipeBlock;
import net.silentchaos512.mechanisms.block.pipe.PipeTileEntity;

public final class PipeNetwork
implements IFluidHandler {
    private final IWorldReader world;
    private final Map<BlockPos, Set<Connection>> connections = new HashMap<BlockPos, Set<Connection>>();
    private boolean connectionsBuilt;
    private final FluidTank fluidTank;

    private PipeNetwork(IWorldReader world, Set<BlockPos> wires) {
        this.world = world;
        wires.forEach(pos -> this.connections.put((BlockPos)pos, Collections.emptySet()));
        this.fluidTank = new FluidTank(1000);
    }

    public boolean contains(IWorldReader world, BlockPos pos) {
        return this.world == world && this.connections.containsKey(pos);
    }

    public int getPipeCount() {
        return this.connections.size();
    }

    public Connection getConnection(BlockPos pos, Direction side) {
        if (this.connections.containsKey(pos)) {
            for (Connection connection : this.connections.get(pos)) {
                if (connection.side != side) continue;
                return connection;
            }
        }
        return new Connection(this, side, ConnectionType.NONE);
    }

    void invalidate() {
        this.connections.values().forEach(set -> set.forEach(con -> con.getLazyOptional().invalidate()));
    }

    static PipeNetwork buildNetwork(IWorldReader world, BlockPos pos) {
        Set<BlockPos> pipes = PipeNetwork.buildPipeSet(world, pos);
        return new PipeNetwork(world, pipes);
    }

    private static Set<BlockPos> buildPipeSet(IWorldReader world, BlockPos pos) {
        return PipeNetwork.buildPipeSet(world, pos, new HashSet<BlockPos>());
    }

    private static Set<BlockPos> buildPipeSet(IWorldReader world, BlockPos pos, Set<BlockPos> set) {
        set.add(pos);
        for (Direction side : Direction.values()) {
            BlockPos pos1 = pos.func_177972_a(side);
            if (set.contains(pos1) || !(world.func_175625_s(pos1) instanceof PipeTileEntity)) continue;
            set.add(pos1);
            set.addAll(PipeNetwork.buildPipeSet(world, pos1, set));
        }
        return set;
    }

    private void buildConnections() {
        if (!this.connectionsBuilt) {
            this.connections.keySet().forEach(p -> this.connections.put((BlockPos)p, this.getConnections((IBlockReader)this.world, (BlockPos)p)));
            this.connectionsBuilt = true;
        }
    }

    private Set<Connection> getConnections(IBlockReader world, BlockPos pos) {
        HashSet<Connection> connections = new HashSet<Connection>();
        for (Direction direction : Direction.values()) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(direction));
            if (te == null || te instanceof PipeTileEntity || !te.getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
            ConnectionType type = PipeBlock.getConnection(world.func_180495_p(pos), direction);
            connections.add(new Connection(this, direction, type));
        }
        return connections;
    }

    void moveFluids() {
        this.buildConnections();
        for (Map.Entry<BlockPos, Set<Connection>> entry : this.connections.entrySet()) {
            FluidStack toSend;
            IFluidHandler fluidHandler;
            BlockPos pos = entry.getKey();
            Set<Connection> connections = entry.getValue();
            for (Connection con : connections) {
                if (con.type.canExtract() && (fluidHandler = PipeNetwork.getFluidHandler((IBlockReader)this.world, pos, con.side)) != null && !(toSend = fluidHandler.drain(10, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && this.fill(toSend, IFluidHandler.FluidAction.EXECUTE) > 0) break;
            }
            for (Connection con : connections) {
                if (con.type.canReceive() && (fluidHandler = PipeNetwork.getFluidHandler((IBlockReader)this.world, pos, con.side)) != null && !(toSend = this.drain(10, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && fluidHandler.fill(toSend, IFluidHandler.FluidAction.EXECUTE) > 0) break;
            }
        }
    }

    @Nullable
    private static IFluidHandler getFluidHandler(IBlockReader world, BlockPos pos, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        if (tileEntity != null) {
            return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()).orElse(null);
        }
        return null;
    }

    public String toString() {
        return String.format("PipeNetwork %s, %d pipes", Integer.toHexString(this.hashCode()), this.connections.size());
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidTank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidTank.getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.fluidTank.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fluidTank.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fluidTank.drain(resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.fluidTank.drain(maxDrain, action);
    }

    public static class Connection
    implements IFluidHandler {
        private final PipeNetwork network;
        private final Direction side;
        private final ConnectionType type;
        private final LazyOptional<Connection> lazyOptional;

        Connection(PipeNetwork network, Direction side, ConnectionType type) {
            this.network = network;
            this.side = side;
            this.type = type;
            this.lazyOptional = LazyOptional.of(() -> this);
        }

        public LazyOptional<Connection> getLazyOptional() {
            return this.lazyOptional;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.network.fluidTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.network.fluidTank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.network.fluidTank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.type.canReceive()) {
                return 0;
            }
            return this.network.fluidTank.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.type.canExtract()) {
                return FluidStack.EMPTY;
            }
            return this.network.fluidTank.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!this.type.canExtract()) {
                return FluidStack.EMPTY;
            }
            return this.network.fluidTank.drain(maxDrain, action);
        }
    }
}

