/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.pump;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.mechanisms.block.pump.PumpContainer;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.item.MachineUpgrades;
import net.silentchaos512.mechanisms.util.InventoryUtils;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;
import net.silentchaos512.utils.EnumUtils;

public class PumpTileEntity
extends AbstractMachineBaseTileEntity {
    public static final int ENERGY_PER_BUCKET = 500;
    public static final int PUMP_DELAY = TimeUtils.ticksFromSeconds((float)5.0f);
    public static final int FIELDS_COUNT = 9;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return PumpTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return PumpTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return PumpTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return PumpTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return PumpTileEntity.this.redstoneMode.ordinal();
                }
                case 7: {
                    return Registry.field_212619_h.func_148757_b((Object)PumpTileEntity.this.tank.getFluid().getFluid());
                }
                case 8: {
                    return PumpTileEntity.this.tank.getFluid().getAmount();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    PumpTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                }
            }
        }

        public int func_221478_a() {
            return 9;
        }
    };
    private final FluidTank tank = new FluidTank(4000);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);

    public PumpTileEntity() {
        super(ModTileEntities.pump, 2, 10000, 100, 0, MachineTier.STANDARD);
    }

    private int getHorizontalRange() {
        return 3 + this.getUpgradeCount(MachineUpgrades.RANGE) * 2;
    }

    private int getVerticalRange() {
        return 64;
    }

    private int getEnergyPerOperation() {
        return (int)(500.0f * this.getUpgradesEnergyMultiplier());
    }

    private int getPumpDelay() {
        int upgrades = this.getUpgradeCount(MachineUpgrades.PROCESSING_SPEED);
        return (int)((float)PUMP_DELAY / (1.0f + (float)upgrades * 0.5f));
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.tryFillFluidContainer();
        if (!this.canMachineRun() || this.field_145850_b.func_82737_E() % (long)this.getPumpDelay() != 0L) {
            return;
        }
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int y = this.field_174879_c.func_177956_o(); y > Math.max(0, this.field_174879_c.func_177956_o() - this.getVerticalRange()); --y) {
            int range = this.getHorizontalRange();
            for (int x = this.field_174879_c.func_177958_n() - range; x <= this.field_174879_c.func_177958_n() + range; ++x) {
                for (int z = this.field_174879_c.func_177952_p() - range; z <= this.field_174879_c.func_177952_p() + range; ++z) {
                    blockPos.func_181079_c(x, y, z);
                    BlockState state = this.field_145850_b.func_180495_p((BlockPos)blockPos);
                    if (!this.tryPumpFluid(blockPos, x, y, z, state)) continue;
                    return;
                }
            }
        }
    }

    private boolean tryPumpFluid(BlockPos.Mutable blockPos, int x, int y, int z, BlockState state) {
        if (state.func_177230_c() instanceof IBucketPickupHandler) {
            assert (this.field_145850_b != null);
            Fluid fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)this.field_145850_b, (BlockPos)blockPos, state);
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            if (!fluidStack.isEmpty() && this.tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                this.energy.consumeEnergy(this.getEnergyPerOperation());
                return true;
            }
        }
        return false;
    }

    private void tryFillFluidContainer() {
        ItemStack filled;
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b()) {
            return;
        }
        FluidStack fluidInInput = IFluidContainer.getBucketOrContainerFluid(input);
        if (!fluidInInput.isEmpty()) {
            return;
        }
        FluidStack fluidInTank = this.tank.getFluidInTank(0);
        if (fluidInTank.getAmount() >= 1000 && !(filled = IFluidContainer.fillBucketOrFluidContainer(input, fluidInTank)).func_190926_b() && InventoryUtils.mergeItem((IInventory)this, filled, 1)) {
            this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            input.func_190918_g(1);
        }
    }

    private boolean canMachineRun() {
        return this.field_145850_b != null && this.getEnergyStored() >= this.getEnergyPerOperation() && this.tank.getCapacity() - this.tank.getFluidAmount() >= 1000 && this.redstoneMode.shouldRun(this.field_145850_b.func_175687_A(this.field_174879_c) > 0);
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0 && InventoryUtils.isEmptyFluidContainer(itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "pump", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new PumpContainer(id, player, this, this.fields);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        this.tank.readFromNBT(tags.func_74775_l("Tank"));
        super.func_230337_a_(state, tags);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags.func_218657_a("Tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tags);
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.fluidCap.cast());
        }
        return super.getCapability(cap, side);
    }
}

