/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterContainer;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterScreen;
import net.silentchaos512.mechanisms.block.compressor.CompressorContainer;
import net.silentchaos512.mechanisms.block.compressor.CompressorScreen;
import net.silentchaos512.mechanisms.block.crusher.CrusherContainer;
import net.silentchaos512.mechanisms.block.crusher.CrusherScreen;
import net.silentchaos512.mechanisms.block.dryingrack.DryingRackBlock;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceContainer;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceScreen;
import net.silentchaos512.mechanisms.block.infuser.InfuserScreen;
import net.silentchaos512.mechanisms.block.mixer.MixerScreen;
import net.silentchaos512.mechanisms.block.refinery.RefineryScreen;
import net.silentchaos512.mechanisms.block.solidifier.SolidifierScreen;
import net.silentchaos512.mechanisms.compat.jei.AlloySmeltingRecipeCategoryJei;
import net.silentchaos512.mechanisms.compat.jei.CompressingRecipeCategoryJei;
import net.silentchaos512.mechanisms.compat.jei.CrushingRecipeCategoryJei;
import net.silentchaos512.mechanisms.compat.jei.DryingRecipeCategoryJei;
import net.silentchaos512.mechanisms.compat.jei.InfusingRecipeCategory;
import net.silentchaos512.mechanisms.compat.jei.MixingRecipeCategory;
import net.silentchaos512.mechanisms.compat.jei.RefiningRecipeCategory;
import net.silentchaos512.mechanisms.compat.jei.SolidifyingRecipeCategory;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.init.ModRecipes;
import net.silentchaos512.mechanisms.init.Registration;
import net.silentchaos512.mechanisms.item.CanisterItem;
import net.silentchaos512.mechanisms.util.Constants;

@JeiPlugin
public class SMechanismsJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentMechanisms.getId("plugin/main");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AlloySmeltingRecipeCategoryJei(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressingRecipeCategoryJei(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrushingRecipeCategoryJei(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategoryJei(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RefiningRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidifyingRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.ALLOY_SMELTING), Constants.ALLOY_SMELTING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.COMPRESSING), Constants.COMPRESSING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.CRUSHING), Constants.CRUSHING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.DRYING), Constants.DRYING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.INFUSING), Constants.INFUSING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.MIXING), Constants.MIXING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.REFINING), Constants.REFINING);
        registration.addRecipes(SMechanismsJeiPlugin.getRecipesOfType(ModRecipes.Types.SOLIDIFYING), Constants.SOLIDIFYING);
    }

    private static List<IRecipe<?>> getRecipesOfType(IRecipeType<?> recipeType) {
        assert (Minecraft.func_71410_x().field_71441_e != null);
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == recipeType).collect(Collectors.toList());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlloySmelterScreen.class, 90, 32, 28, 23, new ResourceLocation[]{Constants.ALLOY_SMELTING});
        registration.addRecipeClickArea(CompressorScreen.class, 78, 32, 28, 23, new ResourceLocation[]{Constants.COMPRESSING});
        registration.addRecipeClickArea(CrusherScreen.class, 45, 32, 28, 23, new ResourceLocation[]{Constants.CRUSHING});
        registration.addRecipeClickArea(ElectricFurnaceScreen.class, 78, 32, 28, 23, new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING, VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeClickArea(InfuserScreen.class, 79, 31, 24, 23, new ResourceLocation[]{Constants.INFUSING});
        registration.addRecipeClickArea(MixerScreen.class, 92, 31, 24, 23, new ResourceLocation[]{Constants.MIXING});
        registration.addRecipeClickArea(RefineryScreen.class, 43, 31, 24, 23, new ResourceLocation[]{Constants.REFINING});
        registration.addRecipeClickArea(SolidifierScreen.class, 79, 31, 24, 23, new ResourceLocation[]{Constants.SOLIDIFYING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AlloySmelterContainer.class, Constants.ALLOY_SMELTING, 0, 4, 5, 36);
        registration.addRecipeTransferHandler(CompressorContainer.class, Constants.COMPRESSING, 0, 1, 2, 36);
        registration.addRecipeTransferHandler(CrusherContainer.class, Constants.CRUSHING, 0, 1, 5, 36);
        registration.addRecipeTransferHandler(ElectricFurnaceContainer.class, Constants.REFINING, 0, 1, 2, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ALLOY_SMELTER), new ResourceLocation[]{Constants.ALLOY_SMELTING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.BASIC_ALLOY_SMELTER), new ResourceLocation[]{Constants.ALLOY_SMELTING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.COMPRESSOR), new ResourceLocation[]{Constants.COMPRESSING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.CRUSHER), new ResourceLocation[]{Constants.CRUSHING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.BASIC_CRUSHER), new ResourceLocation[]{Constants.CRUSHING});
        Registration.getBlocks(DryingRackBlock.class).forEach(block -> registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{Constants.DRYING}));
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ELECTRIC_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING, VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INFUSER), new ResourceLocation[]{Constants.INFUSING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.MIXER), new ResourceLocation[]{Constants.MIXING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.REFINERY), new ResourceLocation[]{Constants.REFINING});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SOLIDIFIER), new ResourceLocation[]{Constants.SOLIDIFYING});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CANISTER.get(), CanisterItem::getFluidKey);
    }
}

