/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.mechanisms.block.solidifier.SolidifierScreen;
import net.silentchaos512.mechanisms.crafting.recipe.SolidifyingRecipe;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.item.CanisterItem;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.mechanisms.util.TextUtil;

public class SolidifyingRecipeCategory
implements IRecipeCategory<SolidifyingRecipe> {
    private static final int GUI_START_X = 33;
    private static final int GUI_START_Y = 13;
    private static final int GUI_WIDTH = 106;
    private static final int GUI_HEIGHT = 65;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public SolidifyingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SolidifierScreen.TEXTURE, 33, 13, 106, 65);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.SOLIDIFIER));
        this.arrow = guiHelper.drawableBuilder(SolidifierScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.solidifying", new Object[0]).getString();
    }

    public ResourceLocation getUid() {
        return Constants.SOLIDIFYING;
    }

    public Class<? extends SolidifyingRecipe> getRecipeClass() {
        return SolidifyingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SolidifyingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getIngredient().getFluids()));
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getFluidOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()));
        ImmutableList emptyContainers = ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151133_ar), (Object)new ItemStack(ModItems.EMPTY_CANISTER));
        ArrayList feedstockContainers = new ArrayList();
        recipe.getIngredient().getFluids().forEach(fluid -> SolidifyingRecipeCategory.addFluidContainers(feedstockContainers, fluid.getFluid()));
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(feedstockContainers));
        ingredients.setOutputLists(VanillaTypes.ITEM, Arrays.asList(emptyContainers, Collections.singletonList(recipe.func_77571_b())));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SolidifyingRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        int capacity = 4000;
        fluidStacks.init(0, true, 25, 5, 12, 50, 4000, true, null);
        fluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 2, 2);
        itemStacks.init(1, false, 2, 45);
        itemStacks.init(2, false, 82, 22);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
    }

    public void draw(SolidifyingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 46, 22);
    }

    private static void addFluidContainers(Collection<ItemStack> list, Fluid fluid) {
        ItemStack bucket = new ItemStack((IItemProvider)fluid.func_204524_b());
        if (!bucket.func_190926_b()) {
            list.add(bucket);
        }
        list.add(CanisterItem.getStack(fluid));
    }
}

