/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidInventory;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidRecipe;
import net.silentchaos512.mechanisms.init.ModRecipes;

public class RefiningRecipe
implements IFluidRecipe<IFluidInventory> {
    private final ResourceLocation recipeId;
    private int processTime;
    private FluidIngredient ingredient;
    private final List<FluidStack> outputs = NonNullList.func_191196_a();

    public RefiningRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public FluidIngredient getIngredient() {
        return this.ingredient;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean matches(IFluidInventory inv, World worldIn) {
        return this.ingredient.test(inv.getFluidInTank(0));
    }

    @Override
    public List<FluidStack> getFluidResults(IFluidInventory inv) {
        return this.getFluidOutputs();
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        NonNullList results = NonNullList.func_191196_a();
        this.outputs.forEach(arg_0 -> RefiningRecipe.lambda$getFluidOutputs$0((List)results, arg_0));
        return results;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return Collections.singletonList(this.ingredient);
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.REFINING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.Types.REFINING;
    }

    public boolean func_192399_d() {
        return true;
    }

    private static /* synthetic */ void lambda$getFluidOutputs$0(List results, FluidStack s) {
        results.add(s.copy());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RefiningRecipe> {
        public RefiningRecipe read(ResourceLocation recipeId, JsonObject json) {
            RefiningRecipe recipe = new RefiningRecipe(recipeId);
            recipe.processTime = JSONUtils.func_151203_m((JsonObject)json, (String)"process_time");
            recipe.ingredient = FluidIngredient.deserialize(json.getAsJsonObject("ingredient"));
            for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"results")) {
                FluidStack stack = IFluidRecipe.deserializeFluid(je.getAsJsonObject());
                if (stack.isEmpty()) continue;
                recipe.outputs.add(stack);
            }
            return recipe;
        }

        @Nullable
        public RefiningRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            RefiningRecipe recipe = new RefiningRecipe(recipeId);
            recipe.processTime = buffer.func_150792_a();
            recipe.ingredient = FluidIngredient.read(buffer);
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                FluidStack stack = IFluidRecipe.readFluid(buffer);
                if (stack.isEmpty()) continue;
                recipe.outputs.add(stack);
            }
            return recipe;
        }

        public void write(PacketBuffer buffer, RefiningRecipe recipe) {
            buffer.func_150787_b(recipe.processTime);
            recipe.ingredient.write(buffer);
            buffer.writeByte(recipe.outputs.size());
            recipe.outputs.forEach(s -> IFluidRecipe.writeFluid(buffer, s));
        }
    }
}

