/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.init.ModRecipes;

public final class InfusingRecipeBuilder {
    private final Ingredient ingredient;
    private final FluidIngredient fluid;
    private final ItemStack result;
    private final int processTime;

    private InfusingRecipeBuilder(Ingredient ingredient, FluidIngredient fluid, ItemStack result, int processTime) {
        this.ingredient = ingredient;
        this.fluid = fluid;
        this.result = result;
        this.processTime = processTime;
    }

    public static InfusingRecipeBuilder builder(IItemProvider result, int count, int processTime, Ingredient ingredient, FluidIngredient fluid) {
        return new InfusingRecipeBuilder(ingredient, fluid, new ItemStack(result, count), processTime);
    }

    public static InfusingRecipeBuilder builder(IItemProvider result, int count, int processTime, ITag<Item> ingredient, FluidIngredient fluid) {
        return InfusingRecipeBuilder.builder(result, count, processTime, Ingredient.func_199805_a(ingredient), fluid);
    }

    public static InfusingRecipeBuilder builder(IItemProvider result, int count, int processTime, IItemProvider ingredient, FluidIngredient fluid) {
        return InfusingRecipeBuilder.builder(result, count, processTime, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), fluid);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation resultId = NameUtils.fromItem((ItemStack)this.result);
        ResourceLocation id = new ResourceLocation("minecraft".equals(resultId.func_110624_b()) ? "silents_mechanisms" : resultId.func_110624_b(), "infusing/" + resultId.func_110623_a());
        this.build(consumer, id);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final InfusingRecipeBuilder builder;

        public Result(ResourceLocation id, InfusingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("process_time", (Number)this.builder.processTime);
            json.add("ingredient", this.builder.ingredient.func_200304_c());
            json.add("fluid", (JsonElement)this.builder.fluid.serialize());
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.fromItem((ItemStack)this.builder.result).toString());
            if (this.builder.result.func_190916_E() > 1) {
                result.addProperty("count", (Number)this.builder.result.func_190916_E());
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.INFUSING.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

