/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.util;

import java.util.function.Predicate;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.mechanisms.item.CanisterItem;

public final class InventoryUtils {
    private InventoryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static int getTotalCount(IInventory inventory, Predicate<ItemStack> ingredient) {
        int total = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !ingredient.test(stack)) continue;
            total += stack.func_190916_E();
        }
        return total;
    }

    public static void consumeItems(IInventory inventory, Predicate<ItemStack> ingredient, int amount) {
        int amountLeft = amount;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !ingredient.test(stack)) continue;
            int toRemove = Math.min(amountLeft, stack.func_190916_E());
            stack.func_190918_g(toRemove);
            if (stack.func_190926_b()) {
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
            if ((amountLeft -= toRemove) != 0) continue;
            return;
        }
    }

    public static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.func_190916_E() + b.func_190916_E() <= a.func_77976_d();
    }

    public static boolean mergeItem(IInventory inventory, ItemStack stack, int slot) {
        ItemStack current = inventory.func_70301_a(slot);
        if (current.func_190926_b()) {
            inventory.func_70299_a(slot, stack);
            return true;
        }
        if (InventoryUtils.canItemsStack(stack, current)) {
            current.func_190917_f(stack.func_190916_E());
            return true;
        }
        return false;
    }

    public static boolean isFilledFluidContainer(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof BucketItem && ((BucketItem)item).getFluid() != Fluids.field_204541_a || item instanceof CanisterItem && !((CanisterItem)item).getFluid(stack).isEmpty();
    }

    public static boolean isEmptyFluidContainer(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof BucketItem && ((BucketItem)item).getFluid() == Fluids.field_204541_a || item instanceof CanisterItem && ((CanisterItem)item).getFluid(stack).isEmpty();
    }

    public static boolean canFluidsStack(FluidStack stack, FluidStack output) {
        return output.isEmpty() || output.isFluidEqual(stack) && output.getAmount() + stack.getAmount() <= 4000;
    }
}

