/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.util.color;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.util.NameUtils;

public final class ColorGetter {
    private static final Cache<ResourceLocation, Integer> FLUID_COLORS = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    private ColorGetter() {
    }

    public static int getColor(Fluid fluid) {
        try {
            return (Integer)FLUID_COLORS.get((Object)NameUtils.from((IForgeRegistryEntry)fluid), () -> ColorGetter.getFluidColor(fluid));
        }
        catch (ExecutionException executionException) {
            return ColorGetter.getFluidColor(fluid);
        }
    }

    private static int getFluidColor(Fluid fluid) {
        TextureAtlasSprite[] sprites;
        if (fluid == Fluids.field_204546_a) {
            return 38143;
        }
        if (ModList.get().isLoaded("jei") && (sprites = ForgeHooksClient.getFluidSprites((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)BlockPos.field_177992_a, (FluidState)fluid.func_207188_f())).length > 0) {
            return ColorGetter.getColor(sprites[0]);
        }
        return 0xFFFFFF;
    }

    public static int getColor(TextureAtlasSprite sprite) {
        if (ModList.get().isLoaded("jei")) {
            List colors = mezz.jei.color.ColorGetter.INSTANCE.getColors(sprite, 0xFFFFFF, 1);
            return colors.isEmpty() ? 0xFFFFFF : (Integer)colors.get(0);
        }
        return 0xFFFFFF;
    }
}

