/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.client.screen.components.GuiSliderInt;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketDestructionGUI;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DestructionGUI
extends Screen {
    private final Set<GuiDestructionSlider> sliders = new HashSet<GuiDestructionSlider>();
    private GuiDestructionSlider left;
    private GuiDestructionSlider right;
    private GuiDestructionSlider up;
    private GuiDestructionSlider down;
    private GuiDestructionSlider depth;
    private Button confirm;
    private String sizeString = "";
    private boolean isValidSize = true;
    private final ItemStack destructionTool;

    public DestructionGUI(ItemStack tool) {
        super((ITextComponent)new StringTextComponent("Destruction Gui?!?"));
        this.destructionTool = tool;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        this.confirm = new Button(x - 30 + 32, y + 65, 60, 20, (ITextComponent)new TranslationTextComponent(GuiMod.getLangKeySingle("confirm")), b -> {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            if (this.isWithinBounds()) {
                PacketHandler.sendToServer(new PacketDestructionGUI(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()));
                this.func_231175_as__();
            } else {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)MessageTranslation.DESTRCUT_TOO_LARGE.componentTranslation(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), true);
            }
        });
        this.func_230480_a_((Widget)this.confirm);
        this.func_230480_a_((Widget)new Button(x - 30 - 32, y + 65, 60, 20, (ITextComponent)new TranslationTextComponent(GuiMod.getLangKeySingle("cancel")), b -> this.func_231175_as__()));
        this.sliders.clear();
        this.depth = new GuiDestructionSlider(x - 35, y - 7, GuiTranslation.SINGLE_DEPTH.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "depth"));
        this.sliders.add(this.depth);
        this.right = new GuiDestructionSlider(x + 75, y - 7, GuiTranslation.SINGLE_RIGHT.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "right"));
        this.sliders.add(this.right);
        this.left = new GuiDestructionSlider(x - 140 - 5, y - 7, GuiTranslation.SINGLE_LEFT.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "left"));
        this.sliders.add(this.left);
        this.up = new GuiDestructionSlider(x - 35, y - 35, GuiTranslation.SINGLE_UP.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "up"));
        this.sliders.add(this.up);
        this.down = new GuiDestructionSlider(x - 35, y + 20, GuiTranslation.SINGLE_DOWN.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "down"));
        this.sliders.add(this.down);
        this.updateSizeString();
        this.updateIsValid();
        this.sliders.forEach(gui -> gui.getComponents().forEach(arg_0 -> ((DestructionGUI)this).func_230480_a_(arg_0)));
    }

    private boolean isWithinBounds() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        int dim = (Integer)Config.GADGETS.GADGET_DESTRUCTION.destroySize.get();
        return x <= dim + 1 && y <= dim + 1 && z <= dim;
    }

    private String getSizeString() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        return String.format("%d x %d x %d", x, y, z);
    }

    private void updateIsValid() {
        this.isValidSize = this.isWithinBounds();
        if (!this.isValidSize && this.confirm.field_230693_o_) {
            this.confirm.setFGColor(0xFF2000);
            this.confirm.field_230693_o_ = false;
        }
        if (this.isValidSize && !this.confirm.field_230693_o_) {
            this.confirm.clearFGColor();
            this.confirm.field_230693_o_ = true;
        }
    }

    private void updateSizeString() {
        this.sizeString = this.getSizeString();
    }

    public void func_230430_a_(@Nonnull MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
        DestructionGUI.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)this.sizeString, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 40), (int)(this.isValidSize ? 65280 : 0xFF2000));
        if (!this.isValidSize) {
            DestructionGUI.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)MessageTranslation.DESTRCUT_TOO_LARGE.format(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 50), (int)0xFF2000);
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        for (GuiDestructionSlider slider : this.sliders) {
            slider.func_231000_a__(mouseX, mouseY);
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private class GuiDestructionSlider
    extends GuiSliderInt {
        public static final int width = 70;
        public static final int height = 14;
        private static final int min = 0;
        private static final int max = 16;

        GuiDestructionSlider(int x, int y, String prefix, int current) {
            super(x, y, 70, 14, (ITextComponent)new StringTextComponent(String.format("%s ", prefix)), (ITextComponent)new StringTextComponent(""), 0.0, 16.0, current, false, true, Color.DARK_GRAY, null, (slider, amount) -> {
                slider.setValue(MathHelper.func_76125_a((int)(slider.getValueInt() + amount), (int)0, (int)16));
                slider.updateSlider();
            });
        }

        @Override
        public void updateSlider() {
            super.updateSlider();
            DestructionGUI.this.updateSizeString();
            DestructionGUI.this.updateIsValid();
        }
    }
}

