/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import journeymap.client.JourneymapClient;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.BiomeRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.cartography.render.EndCaveRenderer;
import journeymap.client.cartography.render.EndSurfaceRenderer;
import journeymap.client.cartography.render.NetherRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.cartography.render.TopoRenderer;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.client.render.ComparableBufferedImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class ChunkRenderController {
    private final SurfaceRenderer overWorldSurfaceRenderer = new SurfaceRenderer();
    private final BaseRenderer netherRenderer;
    private final SurfaceRenderer endSurfaceRenderer;
    private final BaseRenderer endCaveRenderer;
    private final BaseRenderer topoRenderer;
    private final BaseRenderer overWorldCaveRenderer = new CaveRenderer(this.overWorldSurfaceRenderer);
    private final BaseRenderer biomeRenderer;

    public ChunkRenderController() {
        this.netherRenderer = new NetherRenderer();
        this.endSurfaceRenderer = new EndSurfaceRenderer();
        this.endCaveRenderer = new EndCaveRenderer(this.endSurfaceRenderer);
        this.topoRenderer = new TopoRenderer();
        this.biomeRenderer = new BiomeRenderer();
    }

    public BaseRenderer getRenderer(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd) {
        block6: {
            try {
                RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
                if (mapType.isUnderground()) {
                    ComparableBufferedImage image = regionImageSet.getChunkImage(chunkMd, mapType);
                    if (image != null) {
                        if (World.field_234919_h_.equals(rCoord.dimension)) {
                            return this.netherRenderer;
                        }
                        if (World.field_234920_i_.equals(rCoord.dimension)) {
                            return this.endCaveRenderer;
                        }
                        return this.overWorldCaveRenderer;
                    }
                    break block6;
                }
                return this.overWorldSurfaceRenderer;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toPartialString(t));
            }
        }
        return null;
    }

    public boolean renderChunk(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd, RegionData regionData) {
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            return false;
        }
        boolean renderOkay = false;
        try {
            RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
            if (mapType.isUnderground()) {
                ComparableBufferedImage chunkSliceImage = regionImageSet.getChunkImage(chunkMd, mapType);
                if (chunkSliceImage != null && (renderOkay = World.field_234919_h_.equals(rCoord.dimension) ? this.netherRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice) : (World.field_234920_i_.equals(rCoord.dimension) ? this.endCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice) : this.overWorldCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice)))) {
                    regionImageSet.setChunkImage(chunkMd, mapType, chunkSliceImage);
                }
            } else if (!World.field_234919_h_.equals(rCoord.dimension)) {
                if (mapType.isTopo()) {
                    ComparableBufferedImage imageTopo = regionImageSet.getChunkImage(chunkMd, MapType.topo(rCoord.dimension));
                    renderOkay = this.topoRenderer.render(imageTopo, regionData, chunkMd, null);
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, MapType.topo(rCoord.dimension), imageTopo);
                    }
                } else if (mapType.isBiome()) {
                    ComparableBufferedImage imageBiome = regionImageSet.getChunkImage(chunkMd, MapType.biome(rCoord.dimension));
                    renderOkay = this.biomeRenderer.render(imageBiome, regionData, chunkMd, null);
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, MapType.biome(rCoord.dimension), imageBiome);
                    }
                } else {
                    ComparableBufferedImage imageNight;
                    ComparableBufferedImage imageDay = regionImageSet.getChunkImage(chunkMd, MapType.day(rCoord.dimension));
                    renderOkay = this.overWorldSurfaceRenderer.render(imageDay, imageNight = regionImageSet.getChunkImage(chunkMd, MapType.night(rCoord.dimension)), regionData, chunkMd);
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, MapType.day(rCoord.dimension), imageDay);
                        regionImageSet.setChunkImage(chunkMd, MapType.night(rCoord.dimension), imageNight);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(e));
            return false;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
        }
        if (!renderOkay && Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug(String.format("Chunk %s render failed for %s", chunkMd.getCoord(), mapType));
        }
        return renderOkay;
    }
}

