/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBBind
extends TombstoneCommand {
    private static final String BIND_LOCATIONS_NBT_LIST = "tb_bind_locations";
    private static final String BIND_LOCATION_NBT_TAG = "location";
    private static final String BIND_LOCATION_ID_NBT_BYTE = "bind_id";
    private static final int BIND_ID_MIN = 1;
    private static final int BIND_ID_MAX = 5;
    private static final SuggestionProvider<CommandSource> SUGGESTION_BIND_IDS = (ctx, build) -> ISuggestionProvider.func_197013_a(IntStream.rangeClosed(1, 5).mapToObj(String::valueOf), (SuggestionsBuilder)build);
    private static final BiPredicate<INBT, Integer> IS_BIND_ID = (nbt, bindId) -> bindId.intValue() == ((CompoundNBT)nbt).func_74771_c(BIND_LOCATION_ID_NBT_BYTE);

    public CommandTBBind(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbbind";
    }

    @Override
    protected Predicate<CommandSource> getInitialRequirement() {
        return p -> true;
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(this::showUsage);
        builder.then(SubCommand.SHOW.literal().executes(this::showBinds));
        builder.then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(this::setBind)).then(Commands.func_197056_a((String)BIND_LOCATION_ID_NBT_BYTE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).suggests(SUGGESTION_BIND_IDS).executes(this::setBind)));
        builder.then(((LiteralArgumentBuilder)SubCommand.TELEPORT.literal().executes(this::teleportBind)).then(Commands.func_197056_a((String)BIND_LOCATION_ID_NBT_BYTE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).suggests(SUGGESTION_BIND_IDS).executes(this::teleportBind)));
        return builder;
    }

    private int showBinds(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportBind.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        NonNullList<Location> locations = this.getLocationList(((CommandSource)ctx.getSource()).func_197028_i(), player);
        if (locations.stream().allMatch(Location::isOrigin)) {
            throw LangKey.MESSAGE_NO_BIND_LOCATION.asCommandException(new Object[0]);
        }
        IntStream.range(0, locations.size()).forEach(i -> {
            Location location = (Location)locations.get(i);
            if (!location.isOrigin()) {
                LangKey.sendSystemMessage((PlayerEntity)player, (ITextComponent)new StringTextComponent(i + 1 + " -> {" + location.x + ", " + location.y + ", " + location.z + ", " + location.getDimString() + "}"));
            }
        });
        return 1;
    }

    private int teleportBind(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportBind.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        int bindId = CommandTBBind.getInteger(ctx, BIND_LOCATION_ID_NBT_BYTE, 0);
        Location location = this.getOrThrowLocation(((CommandSource)ctx.getSource()).func_197035_h(), bindId);
        CommandTBBind.checkAlive((Entity)player);
        CommandTBBind.checkNotSpectator((Entity)player);
        int cd = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.TELEPORT_BIND);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage((PlayerEntity)player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        ServerWorld world = this.getOrThrowWorld(((CommandSource)ctx.getSource()).func_197028_i(), location.dim);
        Location spawnPlace = new SpawnHelper(world, location.getPos()).findSpawnPlace();
        if (spawnPlace.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.TELEPORT_BIND);
        ServerPlayerEntity newEntity = Helper.teleportEntity(player, spawnPlace, world);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage((CommandSource)ctx.getSource(), LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.func_200200_C_(), spawnPlace.x, spawnPlace.y, spawnPlace.z, spawnPlace.getDimString()), false);
        return 1;
    }

    private int setBind(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Location location;
        if ((Integer)ConfigTombstone.general.cooldownTeleportBind.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        int bindId = CommandTBBind.getInteger(ctx, BIND_LOCATION_ID_NBT_BYTE, 0);
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        ListNBT locationList = persistentTag.func_150295_c(BIND_LOCATIONS_NBT_LIST, 10);
        if (!this.findFirstLocationInListNBT(locationList, arg_0 -> CommandTBBind.lambda$setBind$2(location = new Location((Entity)player), arg_0)).isOrigin()) {
            throw LangKey.MESSAGE_EXISTING_BIND_LOCATION.asCommandException(new Object[0]);
        }
        if (bindId == 0) {
            byte id = this.getFirstEmptyIdInListNBT(locationList);
            if (id == -1) {
                this.setOrReplaceLocationInListNBT(locationList, location, bindId).func_74774_a(BIND_LOCATION_ID_NBT_BYTE, (byte)1);
            } else {
                CompoundNBT nbt = NBTStackHelper.setLocation(new CompoundNBT(), BIND_LOCATION_NBT_TAG, location);
                nbt.func_74774_a(BIND_LOCATION_ID_NBT_BYTE, id);
                locationList.add((Object)nbt);
            }
        } else {
            this.setOrReplaceLocationInListNBT(locationList, location, bindId).func_74774_a(BIND_LOCATION_ID_NBT_BYTE, (byte)bindId);
        }
        persistentTag.func_218657_a(BIND_LOCATIONS_NBT_LIST, (INBT)locationList);
        LangKey.MESSAGE_BIND_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
        return 1;
    }

    private Byte getFirstEmptyIdInListNBT(ListNBT locationList) {
        return locationList.stream().map(nbt -> ((CompoundNBT)nbt).func_74771_c(BIND_LOCATION_ID_NBT_BYTE)).filter(id -> id >= 1 && id <= 5).min(Byte::compareTo).orElse((byte)-1);
    }

    private CompoundNBT setOrReplaceLocationInListNBT(ListNBT locationList, Location location, int bindId) {
        return NBTStackHelper.setLocation(locationList.stream().map(CompoundNBT.class::cast).filter(nbt -> IS_BIND_ID.test((INBT)nbt, bindId)).findFirst().orElseGet(() -> {
            CompoundNBT nbt = new CompoundNBT();
            locationList.add((Object)nbt);
            return nbt;
        }), BIND_LOCATION_NBT_TAG, location);
    }

    private Location getOrThrowLocation(ServerPlayerEntity player, int bindId) {
        CompoundNBT persistentTag;
        if (bindId < 0 || bindId > 5 || !(persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player)).func_150297_b(BIND_LOCATIONS_NBT_LIST, 9)) {
            throw LangKey.MESSAGE_INVALID_LOCATION.asCommandException(new Object[0]);
        }
        ListNBT locationList = persistentTag.func_150295_c(BIND_LOCATIONS_NBT_LIST, 10);
        Location location = this.findFirstLocationInListNBT(locationList, bindId == 0 ? nbt -> true : nbt -> IS_BIND_ID.test((INBT)nbt, bindId));
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_BIND_LOCATION.asCommandException(new Object[0]);
        }
        return location;
    }

    private Location findFirstLocationInListNBT(ListNBT locationList, Predicate<INBT> test) {
        return locationList.stream().filter(test).map(nbt -> NBTStackHelper.getLocation((CompoundNBT)nbt, BIND_LOCATION_NBT_TAG)).findFirst().orElse(Location.ORIGIN);
    }

    private NonNullList<Location> getLocationList(MinecraftServer server, ServerPlayerEntity player) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        NonNullList locationInstances = NonNullList.func_191197_a((int)5, (Object)Location.ORIGIN);
        if (persistentTag.func_150297_b(BIND_LOCATIONS_NBT_LIST, 9)) {
            ListNBT locationList = persistentTag.func_150295_c(BIND_LOCATIONS_NBT_LIST, 10);
            Iterator it = locationList.iterator();
            while (it.hasNext()) {
                CompoundNBT data = (CompoundNBT)it.next();
                Location location = NBTStackHelper.getLocation(data, BIND_LOCATION_NBT_TAG);
                if (!location.isOrigin() && !Helper.isInvalidDimension(server, location.dim)) {
                    locationInstances.set(data.func_74771_c(BIND_LOCATION_ID_NBT_BYTE) - 1, (Object)location);
                    continue;
                }
                it.remove();
            }
        }
        return locationInstances;
    }

    private static /* synthetic */ boolean lambda$setBind$2(Location location, INBT nbt) {
        return NBTStackHelper.getLocation((CompoundNBT)nbt, BIND_LOCATION_NBT_TAG).equals(location);
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        TELEPORT;

    }
}

