/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBTeleport
extends TombstoneCommand {
    private static final ResourceLocation DEFAULT_STRUCTURE = new ResourceLocation("minecraft", "village");

    public CommandTBTeleport(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleport";
    }

    @Override
    protected Predicate<CommandSource> getInitialRequirement() {
        return p -> true;
    }

    @Override
    protected ITextComponent getUsage() {
        return new TranslationTextComponent("tombstone.command." + this.getName() + ".default.usage");
    }

    private int showUsage(CommandSource source, SubCommand subCmd) {
        source.func_197030_a((ITextComponent)new TranslationTextComponent("tombstone.command." + this.getName() + "." + subCmd.name().toLowerCase(Locale.US) + ".usage"), false);
        return 1;
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(this::showUsage);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.POS.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSource)c.getSource(), SubCommand.POS))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"source", (ArgumentType)EntityArgument.func_197086_a()).executes(this::showUsage)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(c -> {
            Entity source = EntityArgument.func_197088_a((CommandContext)c, (String)"source");
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)c, (String)"pos");
            return this.teleport((CommandSource)c.getSource(), source, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (ServerWorld)source.field_70170_p);
        })).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(c -> {
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)c, (String)"pos");
            return this.teleport((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"source"), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), DimensionArgument.func_212592_a((CommandContext)c, (String)"dim"));
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.PLAYER.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSource)c.getSource(), SubCommand.PLAYER))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"source", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.showUsage((CommandSource)c.getSource(), SubCommand.PLAYER))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> {
            Entity target = EntityArgument.func_197088_a((CommandContext)c, (String)"target");
            BlockPos targetPos = target.func_233580_cy_();
            return this.teleport((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"source"), targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), (ServerWorld)target.field_70170_p);
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.GRAVE.literal().requires(this.defaultPermission)).executes(c -> this.teleportGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), ((CommandSource)c.getSource()).func_197035_h()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)c, (String)"player")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportGrave((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), EntityArgument.func_197089_d((CommandContext)c, (String)"target"))))))).then(SubCommand.DEATH.literal().executes(c -> this.teleportDeath((CommandSource)c.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.HOME.literal().requires(this.defaultPermission)).executes(c -> this.teleportHome((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), ((CommandSource)c.getSource()).func_197035_h()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportHome((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)c, (String)"player")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportHome((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), EntityArgument.func_197089_d((CommandContext)c, (String)"target"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.DISCOVERY.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSource)c.getSource(), SubCommand.DISCOVERY))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), DEFAULT_STRUCTURE))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGESTION_STRUCTURE).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"structure")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"structure"), DimensionArgument.func_212592_a((CommandContext)c, (String)"dim")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.BIOME.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSource)c.getSource(), SubCommand.BIOME))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.showUsage((CommandSource)c.getSource(), SubCommand.BIOME))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGESTION_BIOME).executes(c -> this.teleportBiome((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), this.getOrThrowBiome((CommandContext<CommandSource>)c, "biome")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(c -> this.teleportBiome((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), this.getOrThrowBiome((CommandContext<CommandSource>)c, "biome"), DimensionArgument.func_212592_a((CommandContext)c, (String)"dim")))))));
        return builder;
    }

    private void onTeleport(CommandSource sender, Entity source, Location destination, ServerWorld targetWorld) {
        Entity newEntity = Helper.teleportEntity(source, destination, targetWorld);
        if (EntityHelper.isValidPlayer(newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.func_200200_C_(), destination.x, destination.y, destination.z, destination.getDimString()), false);
    }

    private int teleport(CommandSource sender, Entity source, int x, int y, int z, ServerWorld targetWorld) {
        CommandTBTeleport.checkAlive(source);
        CommandTBTeleport.checkNotSpectator(source);
        Location sourceLoc = new Location(source);
        Location destLoc = new Location(x, y, z, (World)targetWorld);
        if (sourceLoc.equals(destLoc)) {
            throw LangKey.MESSAGE_SAME_LOCATION.asCommandException(new Object[0]);
        }
        CommandTBTeleport.checkValidPos((World)targetWorld, destLoc.getPos());
        destLoc = new SpawnHelper(targetWorld, Helper.getCloserValidPos((World)targetWorld, destLoc.getPos())).findSpawnPlace();
        if (destLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, source, destLoc, targetWorld);
        return 1;
    }

    private int teleportGrave(CommandSource sender, ServerPlayerEntity player, ServerPlayerEntity target) {
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Entity)player);
        MinecraftServer server = sender.func_197028_i();
        Location lastGrave = DeathHandler.INSTANCE.getLastGrave(server, target);
        if (lastGrave.isOrigin() && (lastGrave = ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((PlayerEntity)target, ModItems.grave_key))).isOrigin()) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        ServerWorld targetWorld = this.getOrThrowWorld(server, lastGrave.dim);
        CommandTBTeleport.checkValidPos((World)targetWorld, lastGrave.getPos());
        this.onTeleport(sender, (Entity)player, lastGrave, targetWorld);
        return 1;
    }

    private int teleportDeath(CommandSource sender) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportDeath.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayerEntity player = sender.func_197035_h();
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Entity)player);
        Location lastDeathLocation = DeathHandler.INSTANCE.getLastDeathLocation((PlayerEntity)player);
        if (lastDeathLocation.isOrigin()) {
            throw LangKey.MESSAGE_NO_DEATH_LOCATION.asCommandException(new Object[0]);
        }
        int cd = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.TELEPORT_DEATH);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage((PlayerEntity)player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        ServerWorld world = this.getOrThrowWorld(sender.func_197028_i(), lastDeathLocation.dim);
        Location location = new SpawnHelper(world, lastDeathLocation.getPos()).findSpawnPlace();
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.TELEPORT_DEATH);
        this.onTeleport(sender, (Entity)player, location, world);
        return 1;
    }

    private int teleportHome(CommandSource sender, ServerPlayerEntity player, ServerPlayerEntity target) {
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Entity)player);
        Pair<ServerWorld, BlockPos> spawnPoint = CommandTBTeleport.getRespawnPoint(sender.func_197028_i(), target);
        Location location = new SpawnHelper((ServerWorld)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight()).findSpawnPlace();
        CommandTBTeleport.checkValidPos((World)spawnPoint.getLeft(), location.getPos());
        this.onTeleport(sender, (Entity)player, location, (ServerWorld)spawnPoint.getLeft());
        return 1;
    }

    public static Pair<ServerWorld, BlockPos> getRespawnPoint(MinecraftServer server, ServerPlayerEntity player) {
        ServerWorld world;
        BlockPos spawnPos = player.func_241140_K_();
        if (spawnPos != null && (world = server.func_71218_a(player.func_241141_L_())) != null) {
            return Pair.of((Object)world, (Object)spawnPos);
        }
        ServerWorld overworld = server.func_241755_D_();
        return Pair.of((Object)overworld, (Object)overworld.func_241135_u_());
    }

    private int teleportDiscovery(CommandSource sender, Entity target, ResourceLocation structureRL) throws CommandException {
        return this.teleportDiscovery(sender, target, structureRL, (ServerWorld)target.field_70170_p);
    }

    private int teleportDiscovery(CommandSource sender, Entity target, ResourceLocation structureRL, ServerWorld world) throws CommandException {
        CommandTBTeleport.checkAlive(target);
        CommandTBTeleport.checkNotSpectator(target);
        if (!ForgeRegistries.STRUCTURE_FEATURES.getKeys().contains(structureRL)) {
            throw LangKey.MESSAGE_NO_STRUCTURE.asCommandException(new Object[0]);
        }
        Location structureLoc = Helper.findNearestStructure(world, target.func_233580_cy_().func_177963_a(Helper.RANDOM.nextGaussian() * 2000.0, 0.0, Helper.RANDOM.nextGaussian() * 2000.0), structureRL, true);
        if (structureLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_STRUCTURE.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, structureLoc.getPos()).findStructurePlace(structureRL);
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, target, spawnLoc, world);
        return 1;
    }

    private int teleportBiome(CommandSource sender, Entity target, Biome biome) throws CommandException {
        return this.teleportBiome(sender, target, biome, (ServerWorld)target.field_70170_p);
    }

    private int teleportBiome(CommandSource sender, Entity target, Biome biome, ServerWorld world) throws CommandException {
        CommandTBTeleport.checkAlive(target);
        CommandTBTeleport.checkNotSpectator(target);
        if (Biomes.field_76783_v.func_240901_a_().equals((Object)biome.getRegistryName())) {
            throw LangKey.MESSAGE_NO_BIOME.asCommandException(new Object[0]);
        }
        Location location = Helper.findNearestBiome(world, target.func_233580_cy_(), biome, true);
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_BIOME.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, location.getPos()).findSpawnPlace();
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, target, spawnLoc, world);
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        POS,
        PLAYER,
        GRAVE,
        DEATH,
        HOME,
        DISCOVERY,
        BIOME;

    }
}

