/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.api.capability.IServantEntity;
import ovh.corail.tombstone.api.capability.ISpellCaster;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.capability.FriendlyAnimalImpl;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.IFriendlyAnimal;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ProtectedGraveGuardianImpl;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.capability.SpellCasterImpl;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.compatibility.CompatibilityCorpse;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.network.CMessageEffect;
import ovh.corail.tombstone.network.CMessageLogin;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDamages;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.spawner.CustomPhantomSpawner;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarting(FMLServerStartingEvent event) {
        TimeHelper.init();
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            CompatibilityCosmeticArmor.instance.handle();
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            CompatibilityFirstAid.instance.handle();
        }
        if (SupportMods.GRAVESTONE.isLoaded()) {
            CompatibilityGraveStone.instance.handle();
        }
        if (SupportMods.CORPSE.isLoaded()) {
            CompatibilityCorpse.instance.handle();
        }
        BackupService.get();
        UpdaterHandler.instance.checkVersion();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStoppingEvent(FMLServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        BackupService.stop();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            ModTriggers.PASS_APRIL_FOOL.trigger(player);
            ModTriggers.CHRISTMAS.trigger(player);
            ModTriggers.HALLOWEEN.trigger(player);
            PacketHandler.sendToPlayer(new CMessageLogin(TimeHelper.getSpecialEvent()), player);
            EntityHelper.syncTBCapability(player, true);
            PacketHandler.sendToPlayer(CooldownHandler.INSTANCE.getCooldownPacket(player), player);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        Helper.initCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = Helper.getServer();
        if (server != null && event.phase == TickEvent.Phase.END) {
            long systemTime;
            if (LAST_BACKUP < TimeHelper.SERVER_START_TIME) {
                LAST_BACKUP = TimeHelper.SERVER_START_TIME;
            } else if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeUnit.MILLISECONDS.toMinutes((systemTime = TimeHelper.systemTime()) - LAST_BACKUP) > (long)((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()).intValue()) {
                LAST_BACKUP = systemTime;
                if (server.func_184103_al().func_181057_v().size() > 0) {
                    CommandTBRecovery.saveAllPlayers(server, success -> {
                        if (((Boolean)ConfigTombstone.recovery.logAutoBackup.get()).booleanValue()) {
                            ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).asLog());
                        }
                    });
                }
            }
            CommandTBAcceptTeleport.cleanTickets();
            CallbackHandler.tick();
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getPlayer().func_208600_a((ITag)FluidTags.field_206959_a) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.aquatic_life)) {
            event.setNewSpeed(event.getNewSpeed() * (EnchantmentHelper.func_185287_i((LivingEntity)event.getPlayer()) ? 2.0f : 10.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            Block block = event.getWorld().func_180495_p(blockPos).func_177230_c();
            return ModBlocks.isAnyGrave(block) || block.func_203417_a(ModTags.Blocks.grave_marbles);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeBreakBlock.get()).booleanValue() && EntityHelper.isValidServerPlayer(event.getPlayer()) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            ServerWorld world = (ServerWorld)event.getWorld();
            if (!world.func_230315_m_().func_242714_a(DimensionType.field_236004_h_)) {
                return;
            }
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean valid = false;
            for (ISpecialSpawner spawner : world.field_241104_N_) {
                if (spawner instanceof PhantomSpawner && !(spawner instanceof CustomPhantomSpawner)) {
                    builder.add((Object)new CustomPhantomSpawner());
                    valid = true;
                    continue;
                }
                if (spawner instanceof VillageSiege && !(spawner instanceof CustomVillageSiege)) {
                    builder.add((Object)new CustomVillageSiege());
                    valid = true;
                    continue;
                }
                builder.add((Object)spawner);
            }
            if (valid) {
                world.field_241104_N_ = builder.build();
            }
        }
        TameableType.init((World)event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        EffectInstance boneShieldEffect;
        ServerPlayerEntity player;
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p.func_201670_d()) {
            return;
        }
        boolean isPlayer = EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving());
        if (isPlayer && event.getEntityLiving().func_70089_S() && (player = (ServerPlayerEntity)event.getEntityLiving()).func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemCastableMagic && EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.concentration) == 0) {
            EntityHelper.setGlobalItemCooldown((PlayerEntity)player, player.func_184607_cu(), 40);
            player.func_184602_cy();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((PlayerEntity)player, new Object[0]);
        }
        if ((boneShieldEffect = event.getEntityLiving().func_70660_b(ModEffects.bone_shield)) != null && !event.getSource().func_76352_a() && !event.getSource().func_94541_c() && event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof IndirectEntityDamageSource)) {
            event.setCanceled(true);
            if (!((EntityDamageSource)event.getSource()).func_180139_w()) {
                Optional.ofNullable(event.getSource().func_76346_g()).filter(Entity::func_70089_S).ifPresent(s -> {
                    float reflectedDamages = event.getAmount() * ((float)MathHelper.func_76125_a((int)boneShieldEffect.func_76458_c(), (int)1, (int)10) / 10.0f);
                    if (reflectedDamages >= 1.0f) {
                        ModSounds.playSoundAllAround(SoundEvents.field_187903_gc, SoundCategory.NEUTRAL, s.field_70170_p, s.func_233580_cy_(), 0.5f, (Helper.RANDOM.nextFloat() - Helper.RANDOM.nextFloat()) * 0.2f + 1.0f);
                        s.func_70097_a(DamageSource.func_92087_a((Entity)event.getEntityLiving()), reflectedDamages);
                    }
                });
            }
            return;
        }
        if (EffectHelper.isUnstableIntangibilityActive(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (DamageType.LIGHTNING.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.lightning_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (DamageType.COLD.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.frost_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (isPlayer) {
            if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
                if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                    event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                        int knowledgeLevel = cap.getTotalPerkPoints();
                        if (knowledgeLevel > 0) {
                            event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                        }
                    });
                }
            } else {
                int alignmentLevel = event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                if (alignmentLevel != 0 && event.getSource().func_76346_g() instanceof LivingEntity) {
                    boolean valid;
                    boolean bl = EntityHelper.isUndead((LivingEntity)event.getSource().func_76346_g()) ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                    if (valid) {
                        float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                        if (amount < 0.5f) {
                            event.setCanceled(true);
                        } else {
                            event.setAmount(amount);
                        }
                    }
                }
            }
            if (EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_233580_cy_())) {
                event.setCanceled(true);
                return;
            }
        }
        if (event.getSource().func_76346_g() instanceof LivingEntity && !event.getSource().func_76346_g().equals((Object)event.getEntity())) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            if (EffectHelper.isPotionActive(attacker, ModEffects.diversion)) {
                EffectHelper.clearEffect(attacker, ModEffects.diversion);
            }
            if (EffectHelper.isPotionActive(attacker, ModEffects.ghostly_shape)) {
                EffectHelper.clearEffect(attacker, ModEffects.ghostly_shape);
                if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)attacker);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70089_S() && event.getEntityLiving().func_110143_aJ() <= event.getAmount() && !event.getEntityLiving().field_70170_p.func_201670_d()) {
            Location location = event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntityLiving(), false);
                    return new Location(cap.getSafeLocation(event.getEntityLiving()));
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                ServerWorld world;
                event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
                event.getEntityLiving().field_70143_R = 0.0f;
                EffectHelper.clearBadEffects(event.getEntityLiving());
                EffectHelper.addEffect(event.getEntityLiving(), Effects.field_76428_l, 600, 9, new boolean[0]);
                if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                    EffectHelper.addEffect(event.getEntityLiving(), Effects.field_188423_x, 600);
                }
                EffectHelper.addEffect(event.getEntityLiving(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntityLiving().func_184102_h();
                ServerWorld serverWorld = world = server != null ? server.func_71218_a(location.dim) : null;
                if (world != null && !(spawn = new SpawnHelper(world, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleportEntity(event.getEntityLiving(), spawn, world);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
                if (ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
                    event.setCanceled(true);
                    event.getEntityLiving().remove(false);
                }
                return;
            }
            if (EventHandler.handlePlayerDamage((ServerPlayerEntity)event.getEntityLiving(), event.getSource())) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean handlePlayerDamage(ServerPlayerEntity player, DamageSource source) {
        ItemStack soul;
        if (ModItems.voodoo_poppet.preventDeath(player, source)) {
            return true;
        }
        ServerWorld targetWorld = player.func_71121_q();
        BlockPos playerPos = player.func_233580_cy_();
        boolean requirePrevention = (Boolean)ConfigTombstone.player_death.preventDeathOutsideWorldBorder.get() != false && Helper.isOutsideWorldBorders((World)targetWorld, playerPos) || (Boolean)ConfigTombstone.player_death.preventDeathOutsideBuildHeight.get() != false && Helper.isOutsideBuildHeight(playerPos);
        ItemStack itemStack = soul = !requirePrevention ? InventoryHelper.findFirstInInventory((PlayerEntity)player, p -> p.func_77973_b() == ModItems.soul_receptacle) : ItemStack.field_190927_a;
        if (requirePrevention || !soul.func_190926_b()) {
            Location spawnPos = new SpawnHelper(targetWorld, Helper.getCloserValidPos((World)targetWorld, playerPos)).findSpawnPlace();
            if (spawnPos.isOrigin() && targetWorld.func_230315_m_().func_242714_a(DimensionType.field_236006_j_)) {
                spawnPos = new SpawnHelper(targetWorld, new BlockPos(0, 70, 0)).findSpawnPlace();
            }
            if (spawnPos.isOrigin()) {
                assert (player.func_184102_h() != null);
                Pair<ServerWorld, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(player.func_184102_h(), player);
                spawnPos = new SpawnHelper((ServerWorld)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
            }
            if (!spawnPos.isOrigin()) {
                if (!requirePrevention) {
                    soul.func_190918_g(1);
                }
                player.func_70606_j(player.func_110138_aP());
                EffectHelper.clearBadEffects((LivingEntity)player);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76443_y, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 1200);
                (requirePrevention ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).sendMessage((PlayerEntity)player, new Object[0]);
                Helper.teleportEntity(player, spawnPos, targetWorld);
                player.field_70143_R = 0.0f;
                return true;
            }
        }
        if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !player.func_175149_v()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.func_200200_C_()).getString()));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        if (Helper.isAprilFoolsDaySnowball(event.getEntityLiving(), event.getSource())) {
            EffectHelper.addEffect(event.getEntityLiving(), Effects.field_76421_d, 200);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(LivingEvent.LivingVisibilityEvent event) {
        double modifierLowPriority = 1.0;
        if (EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.diversion) || EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape)) {
            modifierLowPriority = 0.0;
        } else {
            EffectInstance bait = event.getEntityLiving().func_70660_b(ModEffects.bait);
            if (bait != null) {
                modifierLowPriority *= Math.min((double)bait.func_76458_c() + 1.0, 2.0);
            }
        }
        event.modifyVisibility(modifierLowPriority);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(LivingEvent.LivingVisibilityEvent event) {
        int lvl;
        double modifierDiscretion = Optional.ofNullable(event.getEntityLiving().func_70660_b(ModEffects.discretion)).map(effect -> MathHelper.func_151237_a((double)((double)(effect.func_76458_c() + 1) * 0.1), (double)0.01, (double)1.0)).orElse(0.0);
        double modifierHighPriority = 1.0 - modifierDiscretion;
        if (EntityHelper.isValidPlayer(event.getEntity()) && (lvl = EntityHelper.getPerkLevelWithBonus((PlayerEntity)event.getEntity(), ModPerks.shadow_walker)) > 0) {
            modifierHighPriority *= 1.0 - (double)lvl * 0.1;
        }
        event.modifyVisibility(modifierHighPriority);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && !event.getPlayer().func_175149_v()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            EntityHelper.syncTBCapability(player, false);
            DeathHandler.INSTANCE.handleRespawn(player);
            NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((PlayerEntity)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true).forEach(arg_0 -> ((ServerPlayerEntity)player).func_195064_c(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Map originalEffects;
        if (!EntityHelper.isValidServerPlayer(event.getOriginal()) || !EntityHelper.isValidServerPlayer(event.getPlayer())) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerEntity original = event.getOriginal();
        original.revive();
        original.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(originalCap -> {
            CompoundNBT nbt = (CompoundNBT)originalCap.serializeNBT();
            if (nbt != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.deserializeNBT((INBT)nbt));
            }
        });
        original.remove(false);
        if (((Boolean)ConfigTombstone.compatibility.preserveEffectsOnReturnEndConquered.get()).booleanValue() && !event.isWasDeath() && original.field_70170_p.func_234923_W_() == World.field_234920_i_ && player.func_193076_bZ().isEmpty() && !(originalEffects = original.func_193076_bZ()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag(event.getPlayer()), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.values().stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            if (!event.isCanceled() && event.getEntityLiving() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
            }
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + player.func_200200_C_().getString() + " was canceled by another mod");
            }
        } else {
            boolean isBeyondTheGraveDamage = (Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get() != false && event.getSource() == ModDamages.BEYOND_THE_GRAVE;
            int knowledgeLoss = (Integer)ConfigTombstone.player_death.knowledgeLoss.get() + (isBeyondTheGraveDamage ? 10 : 0);
            if (knowledgeLoss > 0) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.loseKnowledge(player, knowledgeLoss));
                if (isBeyondTheGraveDamage) {
                    ModTriggers.LOST_KNOWLEDGE.trigger(player);
                }
            }
            DeathHandler.INSTANCE.addPlayerDead(player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if ((Integer)SharedConfigTombstone.player_death.xpLoss.get() > -1 && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onHandleSoulbound(LivingDropsEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity()) && !Helper.isRuleKeepInventory(event.getEntity())) {
            DeathHandler.INSTANCE.handleSoulbound((ServerPlayerEntity)event.getEntity(), event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void onDrops(LivingDropsEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) || Helper.isRuleKeepInventory(event.getEntity())) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.func_146103_bH().getName() + " was canceled by another mod");
            return;
        }
        DeathHandler.INSTANCE.handleLoot(player, event.getDrops(), event.getSource());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).orElse("").trim();
        boolean bl = valid = event.getLeft().func_77973_b() == ModItems.grave_plate && event.getRight().func_77973_b().func_206844_a((ITag)Tags.Items.INGOTS_IRON) || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && event.getRight().func_77973_b() == ModItems.grave_dust;
        if (valid) {
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().func_77946_l(), newName));
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getItemInput().func_77973_b() == ModItems.grave_plate && event.getIngredientInput().func_77973_b().func_206844_a((ITag)Tags.Items.INGOTS_IRON) && EngravableHelper.isEngraved(event.getItemResult())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ActionResultType result;
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getHand() == Hand.MAIN_HAND) {
            TileEntity tile;
            boolean requireNerfGhostlyShape;
            boolean bl = requireNerfGhostlyShape = (Boolean)ConfigTombstone.player_death.nerfGhostlyShapeOpenChest.get() != false && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            if (requireNerfGhostlyShape && (tile = event.getWorld().func_175625_s(event.getPos())) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
                EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
                ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)event.getPlayer());
            }
        }
        BlockState blockState = event.getWorld().func_180495_p(event.getPos());
        Block block = blockState.func_177230_c();
        if (!event.isCanceled() && EntityHelper.isValidPlayer(event.getPlayer()) && ModBlocks.isDecorativeGrave(block) && ModTags.Items.magic_books.func_230235_a_((Object)event.getPlayer().func_184592_cb().func_77973_b()) && (result = blockState.func_227031_a_(event.getWorld(), event.getPlayer(), event.getHand(), event.getHitVec())).func_226246_a_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
            if (!event.getWorld().func_201670_d()) {
                CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)event.getPlayer(), event.getPos(), event.getPlayer().func_184592_cb());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().field_70170_p.func_201670_d() && TimeHelper.atInterval(event.getEntityLiving().field_70170_p, 20) && ((Boolean)ConfigTombstone.client.showShieldParticle.get()).booleanValue() && event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
            ModTombstone.PROXY.produceShield(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getTarget() != null) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            if (event.getTarget().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                PacketHandler.sendToPlayer(new CMessageProtection(event.getTarget().func_145782_y(), true), player);
            }
            if (event.getTarget() instanceof FoxEntity) {
                EntityHelper.getFriendlyOwnerId(event.getTarget()).ifPresent(uuid -> PacketHandler.sendToPlayer(new CMessageServant(event.getTarget().func_145782_y(), (UUID)uuid, false), player));
            } else {
                EntityHelper.getServantOwnerId(event.getTarget()).ifPresent(uuid -> PacketHandler.sendToPlayer(new CMessageServant(event.getTarget().func_145782_y(), (UUID)uuid, true), player));
            }
            event.getTarget().getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).filter(ISpellCaster::isCasting).ifPresent(cap -> PacketHandler.sendToPlayer(new CMessageSpellCasting(event.getTarget().func_145782_y(), cap.getCastingColor()), player));
            if (event.getTarget() instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)event.getTarget();
                EffectInstance effect = living.func_70660_b(ModEffects.bone_shield);
                if (effect != null) {
                    PacketHandler.sendToPlayer(new CMessageEffect(living.func_145782_y(), effect), player);
                }
                CompoundNBT tag = living.getPersistentData();
                EffectInstance effectPrayer = living.func_70660_b(ModEffects.prayer);
                if (effectPrayer != null && tag.func_186855_b("prayer") && tag.func_150297_b("pray_type", 2)) {
                    PacketHandler.sendToPlayer(new CMessagePrayer(living.func_145782_y(), tag.func_186857_a("prayer"), tag.func_74765_d("pray_type"), effectPrayer.func_76459_b()), player);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPotionAdded(PotionEvent.PotionApplicableEvent event) {
        Optional.ofNullable(event.getEntityLiving()).map(Entity::func_200600_R).ifPresent(type -> {
            Effect effect = event.getPotionEffect().func_188419_a();
            if (effect == ModEffects.ghostly_shape || effect == ModEffects.preservation || effect == ModEffects.true_sight) {
                event.setResult(EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) ? Event.Result.ALLOW : Event.Result.DENY);
            } else if (EffectHelper.isBadEffect(effect) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.purification)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider((NonNullSupplier<ITBCapability>)((NonNullSupplier)TBCapabilityDefault::new)));
        } else if (event.getObject() instanceof AbstractVillagerEntity || event.getObject() instanceof GolemEntity) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(EntityHelper::getHomeLocation))));
        } else if (event.getObject() instanceof FoxEntity) {
            event.addCapability(FriendlyAnimalProvider.RL, (ICapabilityProvider)new FriendlyAnimalProvider((NonNullSupplier<IFriendlyAnimal>)((NonNullSupplier)FriendlyAnimalImpl::new)));
        } else if (event.getObject() instanceof CreatureEntity && EntityHelper.isUndead((LivingEntity)event.getObject())) {
            event.addCapability(ServantEntityProvider.RL, (ICapabilityProvider)new ServantEntityProvider((NonNullSupplier<IServantEntity>)((NonNullSupplier)ServantEntityImpl::new)));
        }
        if (event.getObject() instanceof MobEntity) {
            event.addCapability(SpellCasterProvider.RL, (ICapabilityProvider)new SpellCasterProvider((NonNullSupplier<ISpellCaster>)((NonNullSupplier)SpellCasterImpl::new)));
        }
        if (event.getObject() instanceof GraveGuardian) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)ProtectedGraveGuardianImpl::new)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidPlayer(event.getPlayer()) && !event.getPlayer().field_70170_p.func_201670_d()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            EntityHelper.syncTBCapability(player, false);
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (server == null) {
                return;
            }
            Optional.ofNullable(server.func_71218_a(event.getFrom())).ifPresent(fromDim -> Optional.ofNullable(server.func_71218_a(event.getTo())).ifPresent(toDim -> {
                long dif = TimeHelper.worldTicks((World)toDim) - TimeHelper.worldTicks((World)fromDim);
                if (dif != 0L) {
                    CooldownHandler.INSTANCE.updateWorldTime(player, dif);
                    IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
                    IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.lost_tablet).forEach(stack -> ModItems.lost_tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((World)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10))));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack = event.getPlayer().func_184586_b(event.getHand());
        if (heldStack.func_77973_b() == ModItems.gift || heldStack.func_77973_b() == ModItems.smoke_ball || heldStack.func_77973_b() == ModItems.dust_of_vanishing) {
            event.setCancellationResult(heldStack.func_77957_a(event.getWorld(), event.getPlayer(), event.getHand()).func_188397_a());
            event.setCanceled(true);
            return;
        }
        if (event.getTarget() instanceof LivingEntity && (heldStack.func_77973_b() instanceof ItemCastableMagic || event.getHand() == Hand.MAIN_HAND && heldStack.func_77973_b() == ModItems.bone_needle)) {
            event.setCancellationResult(heldStack.func_111282_a_(event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldStack = event.getPlayer().func_184614_ca();
        if (heldStack.func_77973_b() == ModItems.ankh_of_pray) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPhantomTime(PhantomSpawnerEvent.TimeForCheck event) {
        if (((Boolean)ConfigTombstone.general.knowledgeReducePhantomSpawn.get()).booleanValue()) {
            event.getPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> event.modifyTimeForCheck((int)((float)event.getTimeForCheck() * (1.0f + (float)cap.getTotalPerkPoints() * 0.1f))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        Cloud cloud;
        ItemStack stack;
        if (event.getThrowable() != null && EntityType.field_200746_al == event.getThrowable().func_200600_R() && event.getThrowable() instanceof SnowballEntity && (stack = ((SnowballEntity)event.getThrowable()).func_184543_l()).func_77973_b() == ModItems.smoke_ball && (cloud = (Cloud)ModEntities.cloud.func_200721_a(event.getThrowable().field_70170_p)) != null) {
            event.getThrowable().func_70106_y();
            event.setCanceled(true);
            cloud.setColor(ModItems.smoke_ball.getColor(stack, 0));
            cloud.func_70107_b(event.getThrowable().func_226277_ct_(), event.getThrowable().func_226278_cu_(), event.getThrowable().func_226281_cx_());
            event.getThrowable().field_70170_p.func_217376_c((Entity)cloud);
            stack.func_190918_g(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d()) {
            if (event.getEntity() instanceof FoxEntity) {
                event.getEntity().getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).filter(IFriendlyAnimal::isActive).ifPresent(cap -> cap.setAI((CreatureEntity)event.getEntity()));
            } else if (PrayerHelper.isValidUndead(event.getEntity())) {
                event.getEntity().getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).filter(IServantEntity::isActive).ifPresent(cap -> cap.setAI((CreatureEntity)event.getEntity()));
            } else if (event.getEntity() instanceof GolemEntity) {
                ((GolemEntity)event.getEntity()).field_70715_bh.field_220892_d.stream().map(PrioritizedGoal::func_220772_j).filter(NearestAttackableTargetGoal.class::isInstance).map(NearestAttackableTargetGoal.class::cast).filter(g -> MobEntity.class.equals((Object)g.field_75307_b)).forEach(g -> {
                    Predicate<LivingEntity> predic = e -> !EntityHelper.isServant((Entity)e);
                    g.field_220779_d.field_221023_h = g.field_220779_d.field_221023_h == null ? predic : g.field_220779_d.field_221023_h.and(predic);
                });
            }
        }
    }
}

