/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;

public class EffectHelper {
    private static final Method METHOD_ON_EFFECT_REMOVED = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70688_c", (Class[])new Class[]{EffectInstance.class});
    public static final Function<Random, Integer> RANDOM_EFFECT_LEVEL = random -> {
        int roll = random.nextInt(100) + 1;
        return roll < 10 ? 4 : (roll < 25 ? 3 : (roll < 45 ? 2 : (roll < 70 ? 1 : 0)));
    };

    public static int getDuration(@Nullable LivingEntity entity, @Nullable Effect effect) {
        EffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.func_70660_b(effect)) != null ? effectInstance.func_76459_b() : 0;
    }

    public static boolean isPotionActive(@Nullable LivingEntity entity, @Nullable Effect effect) {
        return EffectHelper.getDuration(entity, effect) > 0;
    }

    public static boolean isUnstableIntangibilityActive(@Nullable LivingEntity entity) {
        return TimeHelper.inIntervalAfter(EffectHelper.getDuration(entity, ModEffects.unstable_intangibility), 100, 79);
    }

    public static void capDuration(LivingEntity entity, Effect effect, int maxDuration) {
        EffectInstance effectInstance = (EffectInstance)entity.func_193076_bZ().get(effect);
        if (EffectHelper.capEffect(effectInstance, maxDuration)) {
            EffectHelper.clearEffect(entity, effect);
            EffectHelper.addEffect(entity, effectInstance);
        }
    }

    private static boolean capEffect(@Nullable EffectInstance effectInstance, int maxDuration) {
        if (effectInstance == null) {
            return false;
        }
        if (effectInstance.func_76459_b() < maxDuration) {
            return EffectHelper.capEffect(effectInstance.field_230115_j_, maxDuration);
        }
        effectInstance.field_76460_b = maxDuration;
        effectInstance.field_230115_j_ = null;
        return true;
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable Effect effect, int duration) {
        EffectHelper.addEffect(entity, effect, duration, 0, new boolean[0]);
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable Effect effect, int duration, int amplifier, boolean ... params) {
        if (entity != null && effect != null) {
            entity.func_195064_c(new EffectInstance(effect, duration, amplifier, params.length == 0 || params[0], params.length <= 1 || params[1]));
        }
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable EffectInstance effectInstance) {
        if (entity != null && effectInstance != null && effectInstance.func_188419_a() != null) {
            entity.func_195064_c(effectInstance);
        }
    }

    public static void addGhostlyShape(PlayerEntity player) {
        int duration = (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get();
        if (duration > 0) {
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, duration * 20);
        }
    }

    public static boolean isPotionHidden(@Nullable LivingEntity entity, @Nullable Effect effect) {
        EffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.func_70660_b(effect)) != null && effectInstance.func_82720_e() && !effectInstance.func_188418_e();
    }

    public static EffectInstance copyEffectWithHidden(EffectInstance effectInstance) {
        EffectInstance effectCopy = new EffectInstance(effectInstance);
        if (effectInstance.field_230115_j_ != null) {
            effectCopy.field_230115_j_ = EffectHelper.copyEffectWithHidden(effectInstance.field_230115_j_);
        }
        return effectCopy;
    }

    public static void modifyEffectDuration(EffectInstance effectInstance, Function<EffectInstance, Integer> function) {
        effectInstance.field_76460_b = function.apply(effectInstance);
        if (effectInstance.field_230115_j_ != null) {
            EffectHelper.modifyEffectDuration(effectInstance.field_230115_j_, function);
        }
    }

    public static boolean clearEffect(@Nullable LivingEntity entity, Effect effect) {
        if (entity != null && !entity.field_70170_p.func_201670_d()) {
            MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(entity, effect));
            EffectInstance effectInstance = entity.func_184596_c(effect);
            if (effectInstance != null) {
                try {
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, effectInstance);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static void clearEffect(LivingEntity entity, Predicate<Effect> predic) {
        if (!entity.field_70170_p.func_201670_d()) {
            Iterator it = entity.func_193076_bZ().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!predic.test((Effect)entry.getKey())) continue;
                try {
                    MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(entity, (Effect)entry.getKey()));
                    it.remove();
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, entry.getValue());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearBadEffects(@Nullable LivingEntity entity) {
        if (entity != null) {
            EffectHelper.clearEffect(entity, EffectHelper::isHarmful);
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            if (entity.func_225510_bt_()) {
                entity.func_184195_f(false);
            }
        }
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration, boolean isBad) {
        return EffectHelper.getRandomEffect(duration, isBad, true, RANDOM_EFFECT_LEVEL);
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration, boolean isBad, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        return EffectHelper.getRandomEffect(duration, isBad ? EffectHelper::isBadEffect : EffectHelper::isAllowedEffect, acceptInstantEffect, functionEffectLevel);
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration, Predicate<Effect> predic, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        if (!acceptInstantEffect) {
            predic = predic.and(effect -> !effect.func_76403_b());
        }
        return Helper.getRandomInList(ForgeRegistries.POTIONS.getValues().stream().filter(predic).collect(Collectors.toList())).map(effect -> new EffectInstance(effect, effect.func_76403_b() ? 1 : duration, ((Integer)functionEffectLevel.apply(Helper.RANDOM)).intValue())).orElse(null);
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage) {
        EffectHelper.addRandomEffect(player, duration, withMessage, false, true);
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage, boolean isBad, boolean acceptInstantEffect) {
        EffectInstance effect = EffectHelper.getRandomEffect(duration, isBad, acceptInstantEffect, RANDOM_EFFECT_LEVEL);
        if (effect != null) {
            if (withMessage && !effect.func_188419_a().func_76393_a().isEmpty()) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{new TranslationTextComponent(effect.func_188419_a().func_76393_a()).func_230530_a_(StyleType.MESSAGE_SPECIAL)});
            }
            EffectHelper.addEffect((LivingEntity)player, effect);
        }
    }

    public static boolean isHarmful(@Nullable Effect effect) {
        return effect != null && !effect.func_188408_i() && effect.func_220303_e() != EffectType.NEUTRAL;
    }

    public static boolean isBadEffect(@Nullable Effect effect) {
        return effect != null && effect.func_220303_e() == EffectType.HARMFUL && !Helper.containRL((List<String>)((List)ConfigTombstone.general.unhandledHarmfulEffects.get()), effect.getRegistryName());
    }

    public static boolean isBeneficial(@Nullable Effect effect) {
        return effect != null && effect.func_188408_i();
    }

    public static boolean isAllowedEffect(@Nullable EffectInstance effectInstance) {
        return effectInstance != null && EffectHelper.isAllowedEffect(effectInstance.func_188419_a());
    }

    public static boolean isAllowedEffect(@Nullable Effect effect) {
        return effect != null && effect.func_220303_e() == EffectType.BENEFICIAL && effect != ModEffects.ghostly_shape && effect != ModEffects.preservation && !Helper.containRL((List<String>)((List)ConfigTombstone.general.unhandledBeneficialEffects.get()), effect.getRegistryName());
    }

    public static ItemStack createMagicArrows(int count, Effect effect) {
        return EffectHelper.createMagicArrows(count, effect, 0);
    }

    public static ItemStack createMagicArrows(int count, Effect effect, int amplifier) {
        return EffectHelper.createMagicArrows(count, new EffectInstance(effect, 3200, amplifier));
    }

    public static ItemStack createMagicArrows(int count, EffectInstance ... effectInstances) {
        Arrays.stream(effectInstances).filter(e -> e.func_188419_a().func_76403_b()).forEach(e -> {
            e.field_76460_b = 1;
            e.field_230115_j_ = null;
        });
        return NBTStackHelper.setBoolean(NBTStackHelper.setInteger(PotionUtils.func_185184_a((ItemStack)new ItemStack((IItemProvider)Items.field_185167_i, count), (Collection)Lists.newArrayList((Object[])effectInstances)), "CustomPotionColor", effectInstances.length > 1 ? -16777216 : effectInstances[0].func_188419_a().func_76401_j()), "enchanted_arrow", true);
    }

    public static ItemStack createRandomArrows(int count) {
        EffectInstance effect = EffectHelper.getRandomEffect(3200, true);
        if (effect != null) {
            return EffectHelper.createMagicArrows(count, effect);
        }
        return new ItemStack((IItemProvider)Items.field_185166_h, count);
    }

    public static ItemStack createCursedArrows(int count) {
        ArrayList list = new ArrayList();
        IntStream.range(0, 5).forEach(i -> Optional.ofNullable(EffectHelper.getRandomEffect(3200, e -> EffectHelper.isBadEffect(e) && list.stream().noneMatch(instance -> instance.func_188419_a() == e), true, RANDOM_EFFECT_LEVEL)).ifPresent(list::add));
        if (list.size() > 0) {
            return EffectHelper.createMagicArrows(count, list.toArray(new EffectInstance[0]));
        }
        return new ItemStack((IItemProvider)Items.field_185166_h, count);
    }

    public static String getPotency(int amplifier) {
        if (amplifier == 1) {
            return "";
        }
        List romanNumerals = Arrays.stream(RomanNumeral.values()).sorted(Comparator.comparing(e -> ((RomanNumeral)e).value).reversed()).collect(Collectors.toList());
        int i = 0;
        StringBuilder builder = new StringBuilder();
        while (amplifier > 0 && i < romanNumerals.size()) {
            RomanNumeral symbol = (RomanNumeral)((Object)romanNumerals.get(i));
            if (symbol.value <= amplifier) {
                builder.append(symbol.name());
                amplifier -= symbol.value;
                continue;
            }
            ++i;
        }
        return builder.toString();
    }

    private static enum RomanNumeral {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private final int value;

        private RomanNumeral(int value) {
            this.value = value;
        }
    }
}

