/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class PrayerHelper {
    public static boolean exorcism(ServerPlayerEntity player, LivingEntity target, int ignoredAlignment) {
        if (target instanceof ZombieVillagerEntity) {
            ZombieVillagerEntity zombieVillager = (ZombieVillagerEntity)target;
            return Optional.ofNullable(zombieVillager.func_233656_b_(EntityType.field_200756_av, false)).map(villager -> {
                villager.func_213753_a(zombieVillager.func_213700_eh());
                if (zombieVillager.field_223728_bB != null) {
                    villager.func_223716_a(zombieVillager.field_223728_bB);
                }
                if (zombieVillager.field_213793_bB != null) {
                    villager.func_213768_b(new MerchantOffers(zombieVillager.field_213793_bB));
                }
                villager.func_213761_t(zombieVillager.field_213794_bC);
                villager.func_213386_a((IServerWorld)player.func_71121_q(), player.func_71121_q().func_175649_E(villager.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, (Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()));
                Helper.damageItem(player.func_184614_ca(), 3, player, Hand.MAIN_HAND);
                LangKey.MESSAGE_EXORCISM.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTriggers.EXORCISM.trigger(player);
                return true;
            }).orElse(false);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidUndead(Entity entity) {
        EntitySize entitySize;
        if (!(entity instanceof CreatureEntity)) return false;
        if (!EntityHelper.isUndead((LivingEntity)entity)) return false;
        if (entity.func_200600_R() == ModEntities.grave_guardian) return false;
        if (EntityHelper.isBoss((LivingEntity)entity)) return false;
        EntitySize dimensions = entity.func_200600_R().func_220334_j();
        if (!(entitySize.field_220315_a <= 0.8f)) return false;
        if (!(dimensions.field_220316_b <= 2.4f)) return false;
        return true;
    }

    public static boolean undead(ServerPlayerEntity player, LivingEntity target, int alignment) {
        if (alignment < -1 && PrayerHelper.isValidUndead((Entity)target) && player.func_71121_q().func_175659_aa() != Difficulty.PEACEFUL) {
            return target.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).filter(cap -> {
                Optional<UUID> ownerId = cap.getOwnerId();
                return !ownerId.isPresent() || !player.func_146103_bH().getId().equals(ownerId.get());
            }).map(cap -> {
                cap.setOwnerId(player.func_146103_bH().getId());
                if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.necromancer) * 20) {
                    cap.setSpellCaster(ServantEntityImpl.CasterType.getRandomId());
                }
                cap.setAI((CreatureEntity)target);
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                Helper.damageItem(player.func_184614_ca(), 5, player, Hand.MAIN_HAND);
                LangKey.MESSAGE_PRAYER_OF_UNDEAD.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTriggers.PRAYER_OF_UNDEAD.trigger(player);
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static boolean zombify(ServerPlayerEntity player, LivingEntity target, int alignment) {
        if (alignment < 0 && target instanceof VillagerEntity && target.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            VillagerEntity villager = (VillagerEntity)target;
            return Optional.ofNullable(villager.func_233656_b_(EntityType.field_200727_aF, false)).map(zombieVillager -> {
                zombieVillager.func_213386_a((IServerWorld)player.func_71121_q(), player.func_71121_q().func_175649_E(zombieVillager.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
                zombieVillager.func_213792_a(villager.func_213700_eh());
                zombieVillager.func_223727_a((INBT)villager.func_223722_es().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
                zombieVillager.func_213790_g(villager.func_213706_dY().func_222199_a());
                zombieVillager.func_213789_a(villager.func_213708_dV());
                zombieVillager.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> {
                    cap.setOwnerId(player.func_146103_bH().getId());
                    if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.necromancer) * 20) {
                        cap.setSpellCaster(ServantEntityImpl.CasterType.getRandomId());
                    }
                    cap.setAI((CreatureEntity)zombieVillager);
                });
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, -((Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()).intValue()));
                Helper.damageItem(player.func_184614_ca(), 3, player, Hand.MAIN_HAND);
                LangKey.MESSAGE_EXORCISM.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTriggers.ZOMBIFY.trigger(player);
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static boolean empathy(ServerPlayerEntity player, LivingEntity target, int alignment) {
        TameableType tameableType;
        if (alignment > 1 && (tameableType = TameableType.getType((Entity)target)) != null) {
            TameableType.setTamedBy((PlayerEntity)player, (Entity)target);
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
            Helper.damageItem(player.func_184614_ca(), 5, player, Hand.MAIN_HAND);
            LangKey.MESSAGE_PRAY_OF_EMPATHY.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            if (tameableType == TameableType.TAMEABLE) {
                player.field_70170_p.func_72960_a((Entity)target, (byte)7);
            }
            return true;
        }
        return false;
    }

    public static boolean protection(ServerPlayerEntity player, LivingEntity target, int alignment) {
        if (alignment > 0) {
            return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(protCap -> {
                if (!protCap.isActive()) {
                    protCap.apply(target, true);
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, (Integer)ConfigTombstone.alignment.pointsPrayOfProtection.get()));
                    Helper.damageItem(player.func_184614_ca(), 3, player, Hand.MAIN_HAND);
                    LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[]{target.func_200200_C_()});
                    ModTriggers.PRAY_OF_PROTECTION.trigger(player);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public static void onGrave(ServerPlayerEntity player, BlockPos position) {
        BlockPos gravePos = Helper.findGraveAround((IWorld)player.field_70170_p, position);
        if (gravePos != null) {
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                ItemStack offhandStack = player.func_184592_cb();
                if (offhandStack.func_77973_b() == ModItems.familiar_receptacle) {
                    if (ModItems.familiar_receptacle.containSoul(offhandStack)) {
                        if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhandStack) > 0.0) {
                            LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[0]);
                        } else if (ModItems.familiar_receptacle.revive((PlayerEntity)player, gravePos, offhandStack, false)) {
                            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                            cap.reward(player, 5, 0);
                            Helper.damageItem(player.func_184614_ca(), 1, player, Hand.MAIN_HAND);
                            ModTriggers.REVIVE_FAMILIAR.trigger(player);
                            LangKey.MESSAGE_REVIVE_FAMILIAR.sendMessage((PlayerEntity)player, LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0]));
                            offhandStack.func_190918_g(1);
                        } else {
                            offhandStack.func_196083_e("dead_pet");
                            LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])});
                        }
                    } else {
                        LangKey.MESSAGE_EMPTY_RECEPTACLE.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[0]);
                    }
                } else {
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    cap.reward(player, 1, 0);
                    Helper.damageItem(player.func_184614_ca(), 1, player, Hand.MAIN_HAND);
                    ModTriggers.PRAY_ON_GRAVE.trigger(player);
                    if (TimeHelper.isAprilFoolsDay()) {
                        EffectHelper.addEffect((LivingEntity)player, Effects.field_220309_E, TimeHelper.tickFromDay(1));
                    } else if (EffectHelper.clearEffect((LivingEntity)player, Effects.field_220309_E)) {
                        LangKey.MESSAGE_DISPEL_BAD_OMEN.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    }
                    int totalPerkPoints = cap.getTotalPerkPoints();
                    int chancePet = Helper.RANDOM.nextInt(100);
                    if (chancePet <= (TimeHelper.isAprilFoolsDay() ? 30 : totalPerkPoints / 5)) {
                        EntityType.func_220327_a((String)TameableType.getRandomTameableEntityTypeString()).ifPresent(entityType -> {
                            Entity pet = entityType.func_200721_a(player.field_70170_p);
                            if (pet != null) {
                                pet.func_70107_b((double)((float)gravePos.func_177958_n() + Helper.RANDOM.nextFloat()) - 0.5, (double)gravePos.func_177956_o() + 1.0, (double)((float)gravePos.func_177952_p() + Helper.RANDOM.nextFloat()) - 0.5);
                                if (pet instanceof MobEntity) {
                                    ((MobEntity)pet).func_213386_a((IServerWorld)player.func_71121_q(), player.field_70170_p.func_175649_E(pet.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                                }
                                TameableType.setTamedBy((PlayerEntity)player, pet);
                                player.field_70170_p.func_217376_c(pet);
                                LangKey.MESSAGE_SUMMON_FAMILIAR.sendMessage((PlayerEntity)player, new Object[0]);
                            }
                        });
                    }
                    if (TimeHelper.isDateAroundHalloween() || Helper.RANDOM.nextInt(100) <= (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + totalPerkPoints) {
                        EffectHelper.addRandomEffect((PlayerEntity)player, (Integer)SharedConfigTombstone.decorative_grave.cooldownToPray.get() * 5000, true, false, false);
                    }
                }
            });
        } else {
            LangKey.MESSAGE_CANT_PRAY.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[0]);
        }
    }
}

