/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootSerializers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;
import ovh.corail.tombstone.helper.Helper;

public final class UpdaterHandler {
    public static final UpdaterHandler instance = new UpdaterHandler();
    private final FolderName TOMBSTONE_FOLDER = new FolderName("tombstone");
    private final Gson GSON = LootSerializers.func_237388_c_().create();
    private boolean hasVersionChanged = false;

    private UpdaterHandler() {
    }

    private boolean hasVersionChanged() {
        return this.hasVersionChanged;
    }

    private boolean requireUpdate(PoolType poolType) {
        return true;
    }

    public void checkVersion() {
        MinecraftServer server = Helper.getServer();
        if (server != null) {
            File folder = server.func_240776_a_(this.TOMBSTONE_FOLDER).toFile();
            File file = new File(folder, "version.info");
            if (file.exists()) {
                try {
                    if ("6.8.15".equals(new BufferedReader(new FileReader(file)).readLine().trim())) {
                        this.hasVersionChanged = false;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            folder.mkdirs();
            try (FileWriter fw = new FileWriter(file);){
                fw.write("6.8.15");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hasVersionChanged = true;
        }
    }

    @Nullable
    private File getFile(PoolType poolType, boolean isBakFile) {
        MinecraftServer server = Helper.getServer();
        if (server != null) {
            File folder = new File(server.func_240776_a_(this.TOMBSTONE_FOLDER).toFile(), "loottables");
            folder.mkdirs();
            return new File(folder, String.format("%s-pool-%s.%s", "tombstone", poolType.filename, isBakFile ? "bak" : "json"));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public LootPool loadLootPool(PoolType poolType) {
        File file;
        if (this.requireUpdate(poolType)) {
            if (this.hasVersionChanged()) return null;
        }
        if ((file = this.getFile(poolType, false)) == null) return null;
        if (!file.exists()) return null;
        try (BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            LootPool lootPool = (LootPool)this.GSON.fromJson((Reader)reader, LootPool.class);
            return lootPool;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void saveLootPool(PoolType poolType, LootPool lootPool) {
        File file = this.getFile(poolType, false);
        if (file != null) {
            File bakFile;
            if (file.exists() && this.requireUpdate(poolType) && this.hasVersionChanged() && (bakFile = this.getFile(poolType, true)) != null) {
                try {
                    Files.copy((File)file, (File)bakFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
                writer.write(this.GSON.toJson((Object)lootPool));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum PoolType {
        LOST_TREASURE("lost_treasure"),
        CAT_MORNING("cat_morning"),
        CHEST_TREASURE("chest_treasure"),
        UNDEAD_MOB("undead_mob"),
        UNDEAD_BOSS("undead_boss"),
        SEEKER_ROD("seeker_rod");

        private final String filename;

        private PoolType(String filename) {
            this.filename = filename.toLowerCase(Locale.US);
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

