/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemBook {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
        this.withDefaultInfo();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        boolean isEnchantedBook;
        ItemStack mainhand;
        if (stack.func_77973_b() != this || (mainhand = player.func_184614_ca()).func_190926_b()) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        boolean bl = isEnchantedBook = mainhand.func_77973_b() == Items.field_151134_bR;
        if (isEnchantedBook && !((Boolean)ConfigTombstone.magic_item.canDisenchantEnchantedBook.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_DISENCHANTMENT_DENIED_ITEM.getText(new TranslationTextComponent(Items.field_151134_bR.func_77667_c(mainhand)).func_230530_a_(StyleType.TOOLTIP_ITEM)));
        }
        boolean isTetraModular = SupportMods.TETRA.isLoaded() && Optional.ofNullable(mainhand.func_77973_b().getRegistryName()).map(r -> r.func_110624_b().equals(SupportMods.TETRA.func_176610_l()) && r.func_110623_a().startsWith("modular_")).orElse(false) != false;
        Map<Enchantment, Integer> enchantments = this.getDeserializedEnchantments(mainhand);
        if (enchantments.size() == 0) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_DISENCHANTMENT_NO_ENCHANTMENT.getText(new Object[0]));
        }
        if (isEnchantedBook && enchantments.size() == 1) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        Iterator<Map.Entry<Enchantment, Integer>> it = enchantments.entrySet().iterator();
        stack.func_190918_g(1);
        int enchantMax = isTetraModular ? Integer.MAX_VALUE : EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.scribe) + 2;
        int enchantCount = 0;
        while (enchantCount < enchantMax && it.hasNext()) {
            Map.Entry<Enchantment, Integer> entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            map.put(entry.getKey(), entry.getValue());
            EnchantmentHelper.func_82782_a(map, (ItemStack)book);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)book);
            it.remove();
            ++enchantCount;
        }
        int left = enchantments.size();
        if (isEnchantedBook) {
            mainhand.func_190918_g(1);
            if (left > 0) {
                ItemStack oldEnchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)oldEnchantedBook);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)oldEnchantedBook);
            }
        } else {
            if (left == 0) {
                if (mainhand.func_82837_s()) {
                    mainhand.func_82841_c(1);
                } else {
                    mainhand.func_196083_e("RepairCost");
                }
            }
            if (isTetraModular) {
                CompoundNBT tag = mainhand.func_196082_o();
                tag.func_82580_o("Enchantments");
                tag.func_82580_o("StoredEnchantments");
                tag.func_82580_o("EnchantmentMapping");
                tag.func_74778_a("id", UUID.randomUUID().toString());
            }
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)mainhand);
        }
        ModTriggers.USE_DISENCHANTMENT.trigger(player);
        return ISoulConsumer.ConsumeResult.success((ITextComponent)(left == 0 || isEnchantedBook && left == 1 ? LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]) : LangKey.MESSAGE_DISENCHANTMENT_PARTIAL_SUCCESS.getText(left)), 1);
    }
}

