/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CustomContainer;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRecycling
extends ItemBook {
    public ItemBookOfRecycling() {
        super("book_of_recycling", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRecycling.get());
        this.withBetaInfo().withDefaultInfo();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        CompoundNBT searchTag;
        ItemStack mainhand;
        if (stack.func_77973_b() != this || (mainhand = player.func_184614_ca()).func_190926_b()) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_RECYCLING_FAILED.getText(new Object[0]));
        }
        if (Helper.containRL((List<String>)((List)ConfigTombstone.magic_item.deniedItemToRecycle.get()), mainhand.func_77973_b().getRegistryName())) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_RECYCLING_DENIED.getText(new Object[0]));
        }
        if (mainhand.func_77951_h() && !((Boolean)ConfigTombstone.magic_item.canRecycleDamagedItem.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_CANT_RECYCLE_DAMAGED.getText(new Object[0]));
        }
        if (mainhand.func_77978_p() != null && mainhand.func_77978_p().func_150297_b("Items", 9) || mainhand.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_CANT_RECYCLE_CONTAINER.getText(new Object[0]));
        }
        Item searchItem = mainhand.func_77973_b();
        if (mainhand.func_77978_p() == null) {
            searchTag = null;
        } else {
            CompoundNBT tag = mainhand.func_77978_p().func_74737_b();
            if (tag.func_74764_b("Damage")) {
                tag.func_74768_a("Damage", 0);
            }
            tag.func_82580_o("RepairCost");
            tag.func_82580_o("Enchantments");
            searchTag = tag.isEmpty() ? null : tag;
        }
        NonNullList ingredients = NonNullList.func_191196_a();
        ItemStack recipeResult = this.checkAdditionalRecipes(searchItem, (List<ItemStack>)ingredients);
        if (recipeResult.func_190926_b()) {
            ICraftingRecipe recipe = Objects.requireNonNull(player.func_184102_h()).func_199529_aN().func_241447_a_(IRecipeType.field_222149_a).stream().filter(r -> this.compareRecipeResult(searchItem, searchTag, r.func_77571_b())).max(Comparator.comparingLong(r -> r.func_192400_c().stream().filter(i -> !i.func_203189_d()).count())).orElse(null);
            if (recipe == null) {
                return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
            }
            if (recipe.func_77571_b().func_190916_E() > mainhand.func_190916_E()) {
                return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_RECYCLING_NOT_ENOUGH.getText(new Object[0]));
            }
            int count = recipe.func_192400_c().size();
            NonNullList grid = NonNullList.func_191197_a((int)count, (Object)ItemStack.field_190927_a);
            for (int slotId2 = 0; slotId2 < count; ++slotId2) {
                ItemStack[] items;
                ItemStack result;
                Ingredient ing = (Ingredient)recipe.func_192400_c().get(slotId2);
                if (ing.func_203189_d() || (result = (items = ing.func_193365_a())[Helper.RANDOM.nextInt(items.length)]).func_190926_b()) continue;
                grid.set(slotId2, (Object)result.func_77946_l());
            }
            NonNullList remains = recipe.func_179532_b((IInventory)new CustomContainer((PlayerEntity)player, (NonNullList<ItemStack>)grid));
            IntStream.range(0, grid.size()).filter(slotId -> ((ItemStack)remains.get(slotId)).func_190926_b()).mapToObj(arg_0 -> ((NonNullList)grid).get(arg_0)).filter(i -> !i.func_190926_b()).forEach(((List)ingredients)::add);
            recipeResult = recipe.func_77571_b();
        }
        if (ingredients.isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
        }
        int maxRecycle = mainhand.func_190916_E() / recipeResult.func_190916_E();
        stack.func_190918_g(1);
        mainhand.func_190918_g(recipeResult.func_190916_E() * maxRecycle);
        for (ItemStack ingredient : ingredients) {
            int count = ingredient.func_190916_E() * maxRecycle;
            int maxSize = ingredient.func_77976_d();
            int fullStacks = count / maxSize;
            for (int i2 = 0; i2 < fullStacks; ++i2) {
                ItemStack newStack = ingredient.func_77946_l();
                newStack.func_190920_e(maxSize);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)newStack);
            }
            int left = count - fullStacks * maxSize;
            if (left <= 0) continue;
            ItemStack leftStack = ingredient.func_77946_l();
            leftStack.func_190920_e(left);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)leftStack);
        }
        ModTriggers.USE_RECYCLING.trigger(player);
        return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_RECYCLING_SUCCESS.getText(new Object[0]), 1);
    }

    private boolean compareRecipeResult(Item searchItem, @Nullable CompoundNBT searchTag, ItemStack lookup) {
        return lookup.func_77973_b() == searchItem && (lookup.func_77978_p() == null || searchTag != null && searchTag.equals((Object)lookup.func_77978_p()));
    }

    private ItemStack checkAdditionalRecipes(Item searchItem, List<ItemStack> ingredients) {
        if (searchItem == Items.field_222110_op) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151116_aA, 7));
            return new ItemStack((IItemProvider)Items.field_222110_op);
        }
        if (searchItem == Items.field_151138_bX) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151042_j, 7));
            return new ItemStack((IItemProvider)Items.field_151138_bX);
        }
        if (searchItem == Items.field_151136_bY) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151043_k, 7));
            return new ItemStack((IItemProvider)Items.field_151136_bY);
        }
        if (searchItem == Items.field_151125_bZ) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 7));
            return new ItemStack((IItemProvider)Items.field_151125_bZ);
        }
        if (searchItem == Items.field_234757_kL_ || searchItem == Items.field_234756_kK_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 3));
            ingredients.add(new ItemStack((IItemProvider)Items.field_151055_y, 2));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)searchItem);
        }
        if (searchItem == Items.field_234754_kI_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 2));
            ingredients.add(new ItemStack((IItemProvider)Items.field_151055_y));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234754_kI_);
        }
        if (searchItem == Items.field_234758_kU_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 2));
            ingredients.add(new ItemStack((IItemProvider)Items.field_151055_y, 2));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234758_kU_);
        }
        if (searchItem == Items.field_234755_kJ_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i));
            ingredients.add(new ItemStack((IItemProvider)Items.field_151055_y, 2));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234755_kJ_);
        }
        if (searchItem == Items.field_234766_lv_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 4));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234766_lv_);
        }
        if (searchItem == Items.field_234763_ls_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 5));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234763_ls_);
        }
        if (searchItem == Items.field_234764_lt_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 8));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234764_lt_);
        }
        if (searchItem == Items.field_234765_lu_) {
            ingredients.add(new ItemStack((IItemProvider)Items.field_151045_i, 7));
            ingredients.add(new ItemStack((IItemProvider)Items.field_234759_km_));
            return new ItemStack((IItemProvider)Items.field_234765_lu_);
        }
        return ItemStack.field_190927_a;
    }
}

