/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic {
    private static final String ROLL_NBT_SHORT = "roll";
    private static final String IS_BIOME_NBT_BOOL = "is_biome";
    private static final String PLACE_ID_NBT_STRING = "structure_id";
    private static final String PLACE_NBT_LOCATION = "structurePos";

    public ItemLostTablet() {
        super("lost_tablet", () -> SharedConfigTombstone.allowed_magic_items.allowLostTablet.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        Location location = this.getLocation(stack);
        String id = location.isOrigin() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
        this.addItemDesc(tooltip, id, new Object[0]);
        String rl = this.getLocationId(stack);
        if (rl != null) {
            tooltip.add(this.isExploration(stack) ? Helper.getBiomeName(rl) : SupportStructures.getStructureName(rl));
        }
        this.addItemPosition(tooltip, location);
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (stack.func_77973_b() == this && EntityHelper.isValidServerPlayer(entity) && !this.isWakeUp(stack)) {
            int cd;
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            int roll = NBTStackHelper.getShort(stack, ROLL_NBT_SHORT, (short)-1);
            if (roll == -1) {
                roll = Helper.RANDOM.nextInt(100) + EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.treasure_seeker) * 10;
                NBTStackHelper.setShort(stack, ROLL_NBT_SHORT, (short)roll);
            }
            if ((cd = this.getCooldown(world, stack)) <= 0) {
                this.setCooldown(world, stack, TimeHelper.tickFromSecond(500 + Helper.RANDOM.nextInt(301)));
            } else if (cd == 1) {
                if (this.wakeUpMagic(player, stack, Type.get(roll))) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                } else if (Helper.RANDOM.nextBoolean()) {
                    this.setCooldown(world, stack, TimeHelper.tickFromSecond(1500 + Helper.RANDOM.nextInt(301)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    stack.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ModItems.grave_dust, Helper.RANDOM.nextInt(4) + 2));
                    player.field_71069_bz.func_75142_b();
                    ModTriggers.GRAVE_DUST_FROM_BREAKING_TABLET.trigger(player);
                }
            }
        }
    }

    @Override
    public int getCooldown(@Nullable World level, ItemStack stack) {
        return level != null && stack.func_77973_b() == this ? NBTStackHelper.getTimer(TimeHelper.worldTicks(level), stack, "cooldown_time", 1800) : 0;
    }

    private boolean wakeUpMagic(ServerPlayerEntity player, ItemStack stack, Type type) {
        String rl;
        Location location;
        ServerWorld level = player.func_71121_q();
        if (type == Type.EXPLORATION) {
            location = new Location(Helper.getCloserValidPos((World)level, player.func_233580_cy_().func_177963_a(Helper.RANDOM.nextGaussian() * 10000.0 + 500.0, 0.0, Helper.RANDOM.nextGaussian() * 10000.0 + 500.0)), (World)level);
            rl = Objects.requireNonNull(level.func_226691_t_(location.getPos()).getRegistryName()).toString();
        } else {
            if (type == Type.VILLAGE) {
                rl = SupportStructures.VILLAGE.getId();
            } else {
                rl = (Boolean)ConfigTombstone.magic_item.lostTabletSearchModdedStructure.get() != false ? SupportStructures.getRandomStructure(structure -> !SupportStructures.VILLAGE.is((ResourceLocation)structure) && !Helper.containRL((List<String>)((List)ConfigTombstone.magic_item.lostTabletDeniedStructures.get()), structure)) : SupportStructures.getRandomVanillaStructure(structure -> !SupportStructures.VILLAGE.is((ResourceLocation)structure));
                if (rl == null) {
                    type = Type.VILLAGE;
                    rl = SupportStructures.VILLAGE.getId();
                }
            }
            Structure<?> structure2 = SupportStructures.getStructure(rl);
            if (structure2 == null) {
                return false;
            }
            if (((Boolean)ConfigTombstone.magic_item.lostTabletSearchOutsideWorld.get()).booleanValue() && (!SupportStructures.hasStructureInWorld(level, structure2) || Helper.RANDOM.nextFloat() < 0.3f)) {
                MinecraftServer server = level.func_73046_m();
                level = Helper.getRandomInList(SupportStructures.getDimensionTypesForStructure(server, structure2)).map(arg_0 -> ((MinecraftServer)server).func_71218_a(arg_0)).orElse(level);
            }
            location = Helper.findNearestStructure(level, player.func_233580_cy_().func_177963_a(Helper.RANDOM.nextGaussian() * 2000.0, 0.0, Helper.RANDOM.nextGaussian() * 2000.0), rl, true);
        }
        if (location.isOrigin() || !Helper.isValidPos((World)level, location.getPos())) {
            return false;
        }
        NBTStackHelper.setLocation(stack, PLACE_NBT_LOCATION, location);
        NBTStackHelper.setString(stack, PLACE_ID_NBT_STRING, rl);
        switch (type) {
            case EXPLORATION: {
                NBTStackHelper.setBoolean(stack, IS_BIOME_NBT_BOOL, true);
                ModTriggers.FIND_LOST_TABLET_EXPLORATION.trigger(player);
                break;
            }
            case VILLAGE: {
                ModTriggers.FIND_LOST_TABLET_VILLAGE.trigger(player);
                break;
            }
            case TREASURE: {
                ModTriggers.FIND_LOST_TABLET_TREASURE.trigger(player);
            }
        }
        return true;
    }

    @Nullable
    public String getLocationId(ItemStack stack) {
        String id;
        CompoundNBT tag;
        if (stack.func_77973_b() == this && (tag = stack.func_77978_p()) != null && !(id = NBTStackHelper.getString(stack, PLACE_ID_NBT_STRING)).isEmpty()) {
            return id;
        }
        return null;
    }

    public boolean isWakeUp(ItemStack stack) {
        return stack.func_77973_b() == this && this.getLocationId(stack) != null;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return super.canEnchant(world, gravePos, player, stack) && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (this.isWakeUp(stack)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        String rl;
        Location location = this.getLocation(stack);
        String id = this.getLocationId(stack);
        if (id == null || location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((World)world)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        ServerWorld targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        Location spawnLoc = new SpawnHelper(targetWorld, location.getPos()).findStructurePlace(id);
        if (spawnLoc.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((PlayerEntity)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        EntityHelper.setGlobalItemCooldown((PlayerEntity)player, this, 10);
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, PLACE_NBT_LOCATION, spawnLoc);
        if (this.isExploration(stack) && !id.equals(rl = Objects.requireNonNull(world.func_226691_t_(spawnLoc.getPos()).getRegistryName()).toString())) {
            NBTStackHelper.setString(stack, PLACE_ID_NBT_STRING, rl);
        }
        CallbackHandler.addCallback(1, () -> {
            PlayerEntity newPlayer = (PlayerEntity)Helper.teleportEntity(player, spawnLoc, targetWorld);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.USE_LOST_TABLET.trigger(player);
        });
        return true;
    }

    private void resetStack(World world, ItemStack stack) {
        this.setCooldown(world, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.removeLocation(stack, PLACE_NBT_LOCATION);
        NBTStackHelper.removeKeyName(stack, IS_BIOME_NBT_BOOL);
        NBTStackHelper.removeKeyName(stack, PLACE_ID_NBT_STRING);
    }

    public Location getLocation(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, PLACE_NBT_LOCATION);
        }
        return Location.ORIGIN;
    }

    @Override
    protected int getCastingCooldown() {
        return 0;
    }

    @Override
    protected int getUseMax() {
        return 1;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    public boolean isExploration(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, IS_BIOME_NBT_BOOL);
    }

    public static enum Type {
        UNKNOWN,
        EXPLORATION,
        VILLAGE,
        TREASURE;


        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public static Type get(int roll) {
            return roll < 60 ? EXPLORATION : (roll < 90 ? VILLAGE : TREASURE);
        }
    }
}

