/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.BellTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;

public class ItemSeekerRod
extends ItemGeneric {
    protected static final String TARGET_FOUND_NBT_BOOL = "target_found";
    protected static final String SEARCH_COOLDOWN_NBT_LONG = "search_cooldown";
    protected static final String TARGET_NBT_LOCATION = "target_location";

    public ItemSeekerRod() {
        this("seeker_rod", () -> SharedConfigTombstone.allowed_magic_items.allowSeekerRod.get());
        this.withBetaInfo().withEffect();
    }

    protected ItemSeekerRod(String name, BooleanSupplier supplierEnabled) {
        super(name, ItemSeekerRod.getBuilder().func_200917_a(1).func_234689_a_(), supplierEnabled);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        if (Optional.ofNullable(ModTombstone.PROXY.getClientPlayer()).map(p -> !this.isInVillageRange((PlayerEntity)p, stack)).orElse(true).booleanValue()) {
            this.addItemDistance(tooltip, this.getCurrentTarget(stack));
        }
        this.addItemUse(tooltip, NBTStackHelper.getBoolean(stack, "bed_found") ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (EntityHelper.isValidPlayer(context.func_195999_j()) && this.isTargetFound(stack) && this.isInVillageRange(context.func_195999_j(), stack) && context.func_195995_a().equals((Object)this.getCurrentTarget(stack).getPos())) {
            if (!context.func_195999_j().field_70170_p.func_201670_d()) {
                this.giveReward((ServerPlayerEntity)context.func_195999_j(), context.func_195995_a());
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void giveReward(ServerPlayerEntity player, BlockPos targetPos) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, 0));
        player.func_195068_e(300);
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)LootHelper.getSeekerRodReward(player.func_71121_q(), targetPos, (PlayerEntity)player));
        LangKey.MESSAGE_SEEKER_ROD.sendMessage((PlayerEntity)player, new Object[0]);
        player.field_70170_p.func_184133_a(null, targetPos, SoundEvents.field_219604_Z, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (stack.func_77973_b() == this && world != null && EntityHelper.isValidPlayer(entity)) {
            if (world.func_201670_d()) {
                if (isSelected && entity.equals((Object)ModTombstone.PROXY.getClientPlayer()) && this.isInVillageRange((PlayerEntity)entity, stack)) {
                    ClientEventHandler.toDisplay = this.getMessageToDisplay(stack);
                }
            } else {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                if (this.getCurrentTarget(stack).isOrigin()) {
                    if (NBTStackHelper.hasTimer(TimeHelper.worldTicks(player.field_70170_p), stack, SEARCH_COOLDOWN_NBT_LONG, 1200)) {
                        return;
                    }
                    assert (player.func_184102_h() != null);
                    int d1 = (Helper.RANDOM.nextBoolean() ? -400 : 400) + Helper.RANDOM.nextInt(401) - 200;
                    int d2 = Helper.RANDOM.nextInt(1001) - 500;
                    boolean inverse = Helper.RANDOM.nextBoolean();
                    Location loc = Helper.findNearestVillage(player.func_184102_h().func_241755_D_(), player.func_233580_cy_().func_177982_a(inverse ? d2 : d1, 0, inverse ? d1 : d2));
                    if (loc.isOrigin()) {
                        NBTStackHelper.setLong(stack, SEARCH_COOLDOWN_NBT_LONG, TimeHelper.worldTicks(player.field_70170_p) + 1200L);
                    } else {
                        NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, loc);
                    }
                } else if (!this.isTargetFound(stack) && this.isInVillageRange((PlayerEntity)player, stack) && Helper.RANDOM.nextInt(10) == 0) {
                    BlockPos playerPos = player.func_233580_cy_();
                    Helper.getRandomInList(player.func_71121_q().func_212866_a_((playerPos.func_177958_n() >> 4) + Helper.RANDOM.nextInt(3) - 1, (playerPos.func_177952_p() >> 4) + Helper.RANDOM.nextInt(3) - 1).func_177434_r().entrySet().stream().filter(entry -> this.getTargetType().isInstance(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList())).ifPresent(pos -> {
                        NBTStackHelper.setBoolean(stack, TARGET_FOUND_NBT_BOOL, true);
                        NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, new Location((BlockPos)pos, (World)player.func_71121_q()));
                    });
                }
            }
        }
    }

    protected Class<? extends TileEntity> getTargetType() {
        return BellTileEntity.class;
    }

    protected String getMessageToDisplay(ItemStack stack) {
        return (this.isTargetFound(stack) ? LangKey.MESSAGE_USE_SEEKER_ROD : LangKey.MESSAGE_FIND_BELL).getText(new Object[0]).getString();
    }

    public boolean isTargetFound(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, TARGET_FOUND_NBT_BOOL);
    }

    public Location getCurrentTarget(ItemStack stack) {
        return NBTStackHelper.getLocation(stack, TARGET_NBT_LOCATION);
    }

    public boolean isInVillageRange(PlayerEntity player, ItemStack stack) {
        double dz;
        if (!player.field_70170_p.func_234923_W_().equals(World.field_234918_g_)) {
            return false;
        }
        Location targetLocation = this.getCurrentTarget(stack);
        if (targetLocation.isOrigin()) {
            return false;
        }
        double dx = (double)targetLocation.x + 0.5 - player.func_226277_ct_();
        return dx * dx + (dz = (double)targetLocation.z + 0.5 - player.func_226281_cx_()) * dz < 900.0;
    }
}

