/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfCupidity.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        boolean isAncient = this.isAncient(stack);
        this.addItemDesc(tooltip, "", new Object[0]);
        this.addItemDesc(tooltip, isAncient ? "_ancient" : "_not_ancient", new Object[0]);
        this.addItemUse(tooltip, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    protected int getUseMax() {
        return 1;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        if (stack.func_77973_b() == this) {
            this.setUseCount(stack, this.getUseMax());
            NBTStackHelper.setBoolean(stack, "enchant", true);
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                return ISoulConsumer.ConsumeResult.success(2);
            }
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        Location spawnPos;
        boolean isAncient = this.isAncient(stack);
        TileEntity tile = Helper.getRandomInList(new CopyOnWriteArrayList(world.field_147482_g).stream().filter(aTile -> !isAncient && aTile instanceof MobSpawnerTileEntity || aTile instanceof ChestTileEntity && ((LockableLootTileEntity)aTile).field_184284_m != null).collect(Collectors.toList())).orElse(null);
        if (tile != null && Helper.isValidPos((World)world, tile.func_174877_v()) && !(spawnPos = new SpawnHelper(world, tile.func_174877_v()).findSpawnPlace()).isOrigin()) {
            CallbackHandler.addCallback(1, () -> {
                ServerPlayerEntity newPlayer = Helper.teleportEntity(player, spawnPos, world);
                LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newPlayer, new Object[0]);
                if (!isAncient) {
                    newPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(newPlayer, 0, (Integer)ConfigTombstone.alignment.pointsTabletOfCupidity.get()));
                    EffectHelper.addRandomEffect((PlayerEntity)newPlayer, 1200, true, true, false);
                    if (Helper.RANDOM.nextInt(5) == 0 && world.func_72912_H().func_176130_y() != Difficulty.PEACEFUL) {
                        IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> Helper.spawnRandomMob(world, spawnPos.getPos()));
                    }
                }
                ModTriggers.USE_CUPIDITY.trigger(newPlayer);
            });
            return true;
        }
        LangKey.MESSAGE_TABLET_SEARCH_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return true;
    }
}

