/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public class CMessagePrayer {
    private final UUID prayerUUID;
    private final int entityId;
    private final int prayType;
    private final int leftTime;

    public CMessagePrayer(int entityId, UUID prayerUUID, int prayType, int leftTime) {
        this.entityId = entityId;
        this.prayerUUID = prayerUUID;
        this.prayType = prayType;
        this.leftTime = leftTime;
    }

    static CMessagePrayer fromBytes(PacketBuffer buf) {
        return new CMessagePrayer(buf.func_150792_a(), buf.func_179253_g(), buf.readShort(), buf.readInt());
    }

    static void toBytes(CMessagePrayer msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.func_179252_a(msg.prayerUUID);
        buf.writeShort(msg.prayType);
        buf.writeInt(msg.leftTime);
    }

    public static class Handler {
        static void handle(final CMessagePrayer msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
                        if (level != null) {
                            CompoundNBT tag;
                            PlayerEntity prayer = level.func_217371_b(msg.prayerUUID);
                            LivingEntity target = Optional.ofNullable(level.func_73045_a(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).orElse(null);
                            if (prayer != null && target != null && !(tag = target.getPersistentData()).func_186855_b("prayer")) {
                                tag.func_186854_a("prayer", msg.prayerUUID);
                                EffectHelper.addEffect(target, ModEffects.prayer, msg.leftTime, 1, new boolean[0]);
                                ModTombstone.PROXY.producePray(target, msg.prayType, e -> !target.getPersistentData().func_74764_b("prayer") || !prayer.func_184587_cr() || prayer.func_184614_ca().func_77973_b() != ModItems.ankh_of_pray);
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

