/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

public class PerkTreasureSeeker
extends Perk {
    public PerkTreasureSeeker() {
        super("treasure_seeker", new ResourceLocation("tombstone", "textures/item/lost_tablet.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public List<ITextComponent> getCurrentBonusInfo(int level) {
        ArrayList<ITextComponent> bonus = new ArrayList<ITextComponent>();
        bonus.add((ITextComponent)new StringTextComponent("+" + level * 30 + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.getTranslationKey() + ".bonus1")));
        bonus.add((ITextComponent)new StringTextComponent("+" + level * 10 + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.getTranslationKey() + ".bonus2")));
        return bonus;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        int hatBonus = player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModItems.christmas_hat ? 2 : 0;
        switch (TimeHelper.getSpecialEvent()) {
            case APRIL_FOOLS: 
            case CHRISTMAS: {
                return this.getLevelMax();
            }
            case HALLOWEEN: {
                return hatBonus + 3;
            }
        }
        return hatBonus;
    }
}

