/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.hooks;

import com.google.common.base.Predicates;
import com.ldtteam.blockout.hooks.HookManager;
import com.ldtteam.blockout.hooks.IGuiActionCallback;
import com.ldtteam.blockout.hooks.IGuiHookable;
import com.ldtteam.blockout.hooks.TriggerMechanism;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.Nullable;

public final class HookRegistries {
    public static final EntityReg ENTITY_HOOKS = new EntityReg();
    public static final TileEntityReg TILE_ENTITY_HOOKS = new TileEntityReg();
    private static final HookManager<?, ?, ?>[] REGISTRIES = new HookManager[]{TILE_ENTITY_HOOKS, ENTITY_HOOKS};

    public static void tick(long ticks) {
        for (int i = 0; i < REGISTRIES.length; ++i) {
            REGISTRIES[i].tick(ticks);
        }
    }

    public static void render(MatrixStack matrixStack, float partialTicks) {
        for (int i = 0; i < REGISTRIES.length; ++i) {
            REGISTRIES[i].render(matrixStack, partialTicks);
        }
    }

    public static class TileEntityReg
    extends HookManager<TileEntity, TileEntityType<?>, BlockPos> {
        private TileEntityReg() {
        }

        public <T extends TileEntity> void register(TileEntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism<?> trigger) {
            this.register(targetThing, guiLoc, 0L, trigger);
        }

        public <T extends TileEntity> void register(TileEntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism<?> trigger) {
            this.register(targetThing, guiLoc, expirationTime, trigger, IGuiHookable::shouldOpen, IGuiHookable::onOpen, IGuiHookable::onClose);
        }

        public <T extends TileEntity> void register(TileEntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism<?> trigger, @Nullable BiPredicate<T, TriggerMechanism.Type> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.register(targetThing, guiLoc, 0L, trigger, shouldOpen, onOpen, onClose);
        }

        public <T extends TileEntity> void register(TileEntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism<?> trigger, @Nullable BiPredicate<T, TriggerMechanism.Type> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.registerInternal(targetThing, guiLoc, expirationTime, trigger, shouldOpen, onOpen, onClose);
        }

        @Override
        protected List<TileEntity> findTriggered(TileEntityType<?> teType, TriggerMechanism<?> trigger) {
            List<Object> targets;
            Minecraft mc = Minecraft.func_71410_x();
            switch (trigger.getType()) {
                case DISTANCE: {
                    AxisAlignedBB aabb = mc.field_71439_g.func_174813_aQ().func_186662_g(((Double)trigger.getConfig()).doubleValue());
                    int xStart = MathHelper.func_76128_c((double)(aabb.field_72340_a / 16.0));
                    int xEnd = MathHelper.func_76143_f((double)(aabb.field_72336_d / 16.0));
                    int zStart = MathHelper.func_76128_c((double)(aabb.field_72339_c / 16.0));
                    int zEnd = MathHelper.func_76143_f((double)(aabb.field_72334_f / 16.0));
                    targets = new ArrayList<TileEntity>();
                    for (int chunkX = xStart; chunkX < xEnd; ++chunkX) {
                        for (int chunkZ = zStart; chunkZ < zEnd; ++chunkZ) {
                            Chunk chunk = mc.field_71441_e.func_72863_F().func_217205_a(chunkX, chunkZ, false);
                            if (chunk == null) continue;
                            for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                                BlockPos bp = (BlockPos)entry.getKey();
                                TileEntity te = (TileEntity)entry.getValue();
                                if (te.func_200662_C() != teType || !((double)bp.func_177958_n() > aabb.field_72340_a) || !((double)bp.func_177958_n() < aabb.field_72336_d) || !((double)bp.func_177956_o() > aabb.field_72338_b) || !((double)bp.func_177956_o() < aabb.field_72337_e) || !((double)bp.func_177952_p() > aabb.field_72339_c) || !((double)bp.func_177952_p() < aabb.field_72334_f)) continue;
                                targets.add(te);
                            }
                        }
                    }
                    break;
                }
                case RAY_TRACE: {
                    if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                        TileEntity te = mc.field_71441_e.func_175625_s(((BlockRayTraceResult)mc.field_71476_x).func_216350_a());
                        targets = te == null || te.func_200662_C() != teType ? Collections.emptyList() : Arrays.asList(te);
                        break;
                    }
                    targets = Collections.emptyList();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No trigger mechanism for TileEntity and " + trigger.getName() + " trigger.");
                }
            }
            return targets;
        }

        @Override
        protected BlockPos keyMapper(TileEntity thing) {
            return thing.func_174877_v();
        }

        @Override
        protected void translateToGuiBottomCenter(MatrixStack ms, TileEntity thing, float partialTicks) {
            ms.func_227861_a_((double)thing.func_174877_v().func_177958_n() + 0.5, (double)thing.func_174877_v().func_177956_o() + 1.1, (double)thing.func_174877_v().func_177952_p() + 0.5);
        }
    }

    public static class EntityReg
    extends HookManager<Entity, EntityType<?>, Entity> {
        private EntityReg() {
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism<?> trigger) {
            this.register(targetThing, guiLoc, 0L, trigger);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism<?> trigger) {
            this.register(targetThing, guiLoc, expirationTime, trigger, IGuiHookable::shouldOpen, IGuiHookable::onOpen, IGuiHookable::onClose);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism<?> trigger, @Nullable BiPredicate<T, TriggerMechanism.Type> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.register(targetThing, guiLoc, 0L, trigger, shouldOpen, onOpen, onClose);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism<?> trigger, @Nullable BiPredicate<T, TriggerMechanism.Type> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.registerInternal(targetThing, guiLoc, expirationTime, trigger, shouldOpen, onOpen, onClose);
        }

        @Override
        protected List<Entity> findTriggered(EntityType<?> entityType, TriggerMechanism<?> trigger) {
            List targets;
            Minecraft mc = Minecraft.func_71410_x();
            switch (trigger.getType()) {
                case DISTANCE: {
                    targets = mc.field_71441_e.func_217394_a(entityType, mc.field_71439_g.func_174813_aQ().func_186662_g(((Double)trigger.getConfig()).doubleValue()), (Predicate)Predicates.alwaysTrue());
                    break;
                }
                case RAY_TRACE: {
                    if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY) {
                        Entity entity = ((EntityRayTraceResult)mc.field_71476_x).func_216348_a();
                        targets = entity.func_200600_R() == entityType ? Arrays.asList(entity) : Collections.emptyList();
                        break;
                    }
                    targets = Collections.emptyList();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No trigger mechanism for Entity and " + trigger.getName() + " trigger.");
                }
            }
            return targets;
        }

        @Override
        protected Entity keyMapper(Entity thing) {
            return thing;
        }

        @Override
        protected void translateToGuiBottomCenter(MatrixStack ms, Entity entity, float partialTicks) {
            double x = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
            double y = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
            double z = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
            ms.func_227861_a_(x, y + (double)entity.func_213302_cg() + 0.3, z);
        }
    }
}

